/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.beucalc;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import net.enderkitty.beucalc.ButtonHandler;
import net.enderkitty.beucalc.CFGBeu;
import net.enderkitty.beucalc.Config;
import net.enderkitty.beucalc.DispSolarII;
import net.enderkitty.beucalc.KeyCodes;
import net.enderkitty.beucalc.OS;
import net.enderkitty.beucalc.OSValidator;
import net.enderkitty.beucalc.Options;
import net.enderkitty.beucalc.Timer;
import net.enderkitty.beucalc.Util;
import net.enderkitty.beucalc.core.Core;
import net.enderkitty.beucalc.core.Emulator;
import net.enderkitty.beucalc.core.Processor;

public class BeuCalc
extends Applet
implements Emulator,
Runnable,
WindowListener {
    public static final String VERSION_STRING = "v0.6b5";
    public static final int KB_SHIFT = 7;
    public static final int KB_ALPHA = 15;
    public static final int KB_MODE = 39;
    public static final int KB_UP = 23;
    public static final int KB_RIGHT = 31;
    public static final int KB_LEFT = 22;
    public static final int KB_DOWN = 30;
    public static int[] kbchar;
    public static int[] kbact;
    public static final int[] type_res;
    public static final int[] type_rows;
    public static boolean started;
    public static boolean appletMode;
    public static File calcFolder;
    public String configfile;
    public Options options;
    public Config config;
    public Core core;
    public Processor cpu;
    public byte[] rom_data;
    public int[] usrInptArr = new int[32768];
    public Timer timer;
    public boolean[] prev = new boolean[64];
    public boolean[] kb = new boolean[64];
    public boolean[] btkb = new boolean[64];
    public boolean[] button = new boolean[64];
    public int screen_res;
    public int screen_rows;
    public int action;
    public File appDataDir;
    public CFGBeu appdatacfg;
    public BufferedImage bufferedScreen = new BufferedImage(768, 768, 1);
    boolean running = false;
    public String fpsString = "";
    public boolean pause = false;
    public boolean holdS7 = false;
    boolean scrnsht = false;
    private long lastTime;
    private int frames;
    public int mouseX;
    public int mouseY;

    static {
        started = false;
        appletMode = false;
        type_res = new int[]{-1, -1, 4, 5, 6, 6};
        type_rows = new int[]{-1, -1, 16, 33, 64, 64};
        kbchar = new int[128];
        int i = 0;
        while (i < 128) {
            BeuCalc.kbchar[i] = -1;
            ++i;
        }
        BeuCalc.kbchar[Util.byteValue((int)48)] = 52;
        BeuCalc.kbchar[Util.byteValue((int)49)] = 0;
        BeuCalc.kbchar[Util.byteValue((int)50)] = 8;
        BeuCalc.kbchar[Util.byteValue((int)51)] = 16;
        BeuCalc.kbchar[Util.byteValue((int)52)] = 1;
        BeuCalc.kbchar[Util.byteValue((int)53)] = 9;
        BeuCalc.kbchar[Util.byteValue((int)54)] = 17;
        BeuCalc.kbchar[Util.byteValue((int)55)] = 2;
        BeuCalc.kbchar[Util.byteValue((int)56)] = 10;
        BeuCalc.kbchar[Util.byteValue((int)57)] = 18;
        BeuCalc.kbchar[Util.byteValue((int)43)] = 24;
        BeuCalc.kbchar[Util.byteValue((int)45)] = 32;
        BeuCalc.kbchar[Util.byteValue((int)40)] = 19;
        BeuCalc.kbchar[Util.byteValue((int)41)] = 27;
        BeuCalc.kbchar[Util.byteValue((int)42)] = 25;
        BeuCalc.kbchar[Util.byteValue((int)47)] = 33;
        BeuCalc.kbchar[Util.byteValue((int)46)] = 51;
        BeuCalc.kbchar[27] = 34;
        BeuCalc.kbchar[8] = 26;
        BeuCalc.kbchar[10] = 48;
        kbact = new int[32];
        i = 0;
        while (i < 32) {
            BeuCalc.kbact[i] = -1;
            ++i;
        }
    }

    @Override
    public void init() {
        appletMode = true;
    }

    @Override
    public void start() {
        appletMode = true;
        if (!started) {
            this.startEmu();
        }
    }

    public void initOptionData() {
        String s = "beucalc";
        String property = System.getProperty("user.home", ".");
        File mcDataDir = null;
        String lowerCase = System.getProperty("os.name").toLowerCase();
        switch (OSValidator.osValues[(lowerCase.contains("win") ? OS.windows : (lowerCase.contains("mac") ? OS.macos : (lowerCase.contains("solaris") ? OS.solaris : (lowerCase.contains("sunos") ? OS.solaris : (lowerCase.contains("linux") ? OS.linux : (lowerCase.contains("unix") ? OS.linux : OS.unknown)))))).ordinal()]) {
            case 1: 
            case 2: {
                mcDataDir = new File(property, ".beucalc/");
                break;
            }
            case 3: {
                String getenv = System.getenv("APPDATA");
                if (getenv != null) {
                    mcDataDir = new File(getenv, ".beucalc/");
                    break;
                }
                mcDataDir = new File(property, ".beucalc/");
                break;
            }
            case 4: {
                mcDataDir = new File(property, "Library/Application Support/beucalc");
                break;
            }
            default: {
                mcDataDir = new File(property, "beucalc/");
            }
        }
        if (!mcDataDir.exists() && !mcDataDir.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + mcDataDir);
        }
        this.appdatacfg = new CFGBeu(this, mcDataDir);
        this.appDataDir = mcDataDir;
        calcFolder = this.appdatacfg.appdata ? this.appDataDir : new File(System.getProperty("user.dir"));
    }

    public void setAppletConfig() {
        this.configfile = this.getParameter("calc_cfg");
    }

    public void startEmu() {
        started = true;
        this.initOptionData();
        try {
            this.preInitStuff();
        }
        catch (Throwable t) {
            this.handleCrash(t, "Uh Oh! BeuCalc has crashed while pre-init");
            this.running = false;
        }
    }

    public void preInitStuff() {
        if (!appletMode) {
            this.setSize(1024, 768);
        }
        this.options = Options.loadOptions(new File(calcFolder, "options.txt"));
        if (appletMode) {
            this.setAppletConfig();
        }
        this.config = Config.loadConfig(new File(calcFolder, this.configfile));
        this.rom_data = this.loadRom(new File(calcFolder, this.config.romfile));
        if (this.config.calcType == 3 || this.config.calcType == 4) {
            this.initDefaultKeys();
        }
        if (this.config.kbFile != null) {
            this.config.loadKB();
        } else if (KeyCodes.keycodes != null) {
            this.config.loadKBFromRom(this.rom_data);
            if (this.config.calcType == 3) {
                this.config.initButtonKeys();
            }
        }
        new Thread(this).start();
        this.setLayout(null);
        this.initButtons();
    }

    public void initDefaultKeys() {
        BeuCalc.kbact[4] = 23;
        BeuCalc.kbact[5] = 30;
        BeuCalc.kbact[6] = 22;
        BeuCalc.kbact[7] = 31;
        BeuCalc.kbact[8] = 7;
        BeuCalc.kbact[9] = 15;
        BeuCalc.kbact[10] = 39;
    }

    public void initButtons() {
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 7) {
                int ki = 7 ^ y;
                int ko = x;
                Button b = new Button();
                int bbx = 16 + x * 56;
                int bby = 256 + (y << 5);
                b.setBounds(bbx, bby, 48, 24);
                int id = ko << 3 | ki;
                if (this.config.kbLabel[id] != null) {
                    b.setLabel(this.config.kbLabel[id]);
                }
                b.addMouseListener(new ButtonHandler(this, id));
                this.add(b);
                ++x;
            }
            ++y;
        }
        Button b = new Button();
        b.setBounds(44, 192, 48, 24);
        b.setLabel("Reset");
        b.addMouseListener(new ButtonHandler(this, -1));
        this.add(b);
        Button b2 = new Button();
        b2.setBounds(100, 192, 48, 24);
        b2.setLabel("Stp/Strt");
        b2.addMouseListener(new ButtonHandler(this, -2));
        this.add(b2);
        Button b3 = new Button();
        b3.setBounds(156, 192, 48, 24);
        b3.setLabel("ON");
        b3.addMouseListener(new ButtonHandler(this, -3));
        this.add(b3);
        Button b4 = new Button();
        b4.setBounds(268, 192, 80, 24);
        String str0 = "Hold Shift+7";
        if (this.config.calcType == 259) {
            str0 = "Hold Mode+7";
        }
        b4.setLabel(str0);
        b4.addMouseListener(new ButtonHandler(this, -4));
        this.add(b4);
        if (this.config.calcType == 259) {
            Button xtra = new Button();
            int bbx = 408;
            int bby = 480;
            xtra.setBounds(bbx, bby, 48, 24);
            xtra.setLabel("AC");
            xtra.addMouseListener(new ButtonHandler(this, 56));
            this.add(xtra);
        }
    }

    public byte[] loadRom(File f) {
        int size = (int)f.length();
        byte[] rom = new byte[size];
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(f));
            dis.readFully(rom);
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rom;
    }

    public void reset() {
        this.core.on();
        this.core.reset();
        this.core.clearRam();
        this.core.cpu.reg_csr = 0;
        this.core.cpu.reg_pc = this.core.mem.readCode(2);
    }

    public void initGame() {
        if (!Config.isTypeValid(this.config.calcType)) {
            throw new RuntimeException("Unknown calculator type: " + this.config.calcType);
        }
        if (Config.isTypeMain(this.config.calcType)) {
            this.screen_res = type_res[this.config.calcType];
            this.screen_rows = type_rows[this.config.calcType];
        } else {
            if (this.config.calcType == 257) {
                this.config.csrMask = 0;
                this.screen_res = 4;
                this.screen_rows = 16;
                DispSolarII.instance = new DispSolarII();
            }
            if (this.config.calcType == 259) {
                this.screen_res = type_res[3];
                this.screen_rows = 33;
            }
            if (this.config.calcType == 513) {
                this.screen_res = type_res[4];
                this.screen_rows = 64;
            }
        }
        if (this.config.tps > -1) {
            this.timer = new Timer(this.config.tps);
        }
        this.core = new Core(this);
        if (this.core.cfg.csrMask == -1) {
            this.core.cfg.csrMask = Config.getDefaultCSR_MASK(this.config.calcType);
            System.out.println("cMask: " + this.core.cfg.csrMask);
        }
        this.cpu = new Processor(this.core);
        this.loadCode();
        if (this.config.noCSR) {
            System.out.println("SMALL Memory Model!");
            this.cpu.hasCSR = false;
        }
        if (this.config.legacyKO) {
            System.out.println("ko is 0F044h");
        }
        this.core.reset();
    }

    public void loadCode() {
        byte[] codemem = this.rom_data;
        if (this.core.cfg.calcType == 259 && this.core.cfg.flashfile != null) {
            System.out.println("Loading fx-5800P Flash!");
            byte[] flash_data = this.loadRom(new File(calcFolder, this.config.flashfile));
            int i = 0;
            while (i < flash_data.length) {
                this.core.mem.flash[i] = flash_data[i];
                ++i;
            }
            codemem = new byte[0x100000];
            i = 0;
            while (i < this.rom_data.length) {
                codemem[i] = this.rom_data[i];
                ++i;
            }
            i = 0;
            while (i < 262144) {
                codemem[0xC0000 | i] = flash_data[0x40000 | i];
                ++i;
            }
        }
        this.core.setRomData(codemem);
    }

    @Override
    public void setPause(boolean b) {
        this.pause = b;
    }

    @Override
    public boolean isEmuPaused() {
        return this.pause;
    }

    @Override
    public Config getEmuCfg() {
        return this.config;
    }

    @Override
    public void run() {
        System.out.println("BeuCalc v0.6b5");
        this.running = true;
        try {
            this.initGame();
            this.core.cpu.reg_csr = 0;
            this.core.cpu.reg_pc = this.core.mem.readCode(2);
            this.core.run = true;
            this.requestFocus();
            this.core.tmr.start();
        }
        catch (Throwable t) {
            this.handleCrash(t, "Uh Oh! BeuCalc has crashed while initializing");
            this.running = false;
        }
        this.lastTime = System.currentTimeMillis();
        this.frames = 0;
        try {
            while (this.running) {
                if (this.timer != null) {
                    this.timer.advanceTime();
                    int i = 0;
                    while (i < this.timer.ticks) {
                        this.tick();
                        ++i;
                    }
                } else {
                    this.tick();
                }
                this.repaint();
            }
        }
        catch (Throwable t) {
            this.handleCrash(t, "Uh Oh! BeuCalc has crashed :(");
            this.stopEmu();
        }
        System.out.println("Closing!");
        System.exit(0);
    }

    public void stopEmu() {
        this.running = false;
    }

    public void testCPU() {
        int good = 0;
        int i = 0;
        while (i < 65536) {
            this.pause = false;
            this.core.cpu.executeOP(i);
            if (!this.pause) {
                ++good;
            }
            ++i;
        }
        System.out.println(good);
        System.exit(0);
    }

    public void tick() {
        if (this.core.cfg.emuROM) {
            this.updatePrev();
        }
        if (this.usrInptArr[32] != 0) {
            this.pause = !this.pause;
            this.usrInptArr[32] = 0;
        }
        if (this.usrInptArr[1011] != 0) {
            this.action = -3;
            this.usrInptArr[1011] = 0;
        }
        if (this.usrInptArr[1013] != 0) {
            this.scrnsht = true;
            this.usrInptArr[1013] = 0;
        }
        if ((this.usrInptArr[1014] & this.usrInptArr[1015] & this.usrInptArr[1016]) != 0 && this.isLetterDown('C')) {
            this.manualCrash();
        }
        this.updateClicked();
        this.checkKeys();
        this.checkButtons();
        if (!this.pause) {
            this.core.tick();
        }
        this.checkButtons();
        this.nextAction();
    }

    public void manualCrash() {
        throw new RuntimeException("Manual Crash");
    }

    public void nextAction() {
        if (this.action == -1) {
            this.reset();
        }
        if (this.action == -3) {
            this.core.on();
        }
        if (this.action == -6) {
            this.scrnsht = true;
        }
        if (this.action == -64 && this.config.calcType == 259) {
            this.core.cpu.reg_csr = 1;
            this.core.cpu.reg_pc = 40228;
            this.core.resetSP();
        }
        this.action = 0;
    }

    public void checkKeys() {
        int i = 8;
        while (i < 127) {
            if (kbchar[i] > -1 && !this.button[kbchar[i]]) {
                this.kb[BeuCalc.kbchar[i]] = this.usrInptArr[i] > 0;
            }
            ++i;
        }
        if (kbchar[8] > -1 && kbchar[127] == -1 && this.usrInptArr[127] > 0) {
            this.kb[BeuCalc.kbchar[8]] = true;
        }
        i = 1000;
        while (i < 1032) {
            int indx = i - 1000;
            if (kbact[indx] > -1 && !this.button[kbact[indx]]) {
                this.kb[BeuCalc.kbact[indx]] = this.usrInptArr[i] > 0;
            }
            ++i;
        }
    }

    public void updateClicked() {
        int i = 0;
        while (i < 64) {
            this.kb[i] = this.btkb[i];
            ++i;
        }
    }

    @Override
    public boolean isEmuACDown(int emu_ki, int emu_ko) {
        boolean ko;
        boolean ki = (emu_ki & 4) == 4;
        boolean bl = ko = (emu_ko & 0x10) == 16;
        return this.kb[34] || ki && ko;
    }

    public void freeze(long t) {
        try {
            Thread.sleep(t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int diagKI() {
        if (this.core.cfg.calcType == 5) {
            return 219;
        }
        if (this.core.cfg.calcType == 257) {
            return 219;
        }
        return 123;
    }

    public void updatePrev() {
        int i = 0;
        while (i < 64) {
            this.prev[i] = this.kb[i];
            ++i;
        }
    }

    public int getKO() {
        if (this.core.cfg.legacyKO) {
            return 0xFF ^ this.core.mem.readDataByte(61508);
        }
        return this.core.mem.readDataByte(61510);
    }

    public void checkButtons() {
        int koWord;
        int pdMask;
        int pd;
        if (this.core.cfg.emuROM) {
            this.checkButtonsEmu();
        }
        int ki = 255;
        int koMask = this.getKO();
        int i = 0;
        while (i < 64) {
            boolean ko;
            int y = i & 7;
            int x = i >>> 3;
            int bki = 0xFF ^ 1 << y;
            int bko = 1 << x;
            boolean bl = ko = (koMask & bko) != 0;
            if (this.kb[i] && ko) {
                this.core.raiseInt(5);
                ki &= bki;
            }
            ++i;
        }
        if (!(this.core.cfg.legacyKO || (pd = this.core.cfg.pd) <= -1 || this.core.isClasswiz() || this.core.cfg.emuROM || (pd & (pdMask = Util.byteValue((koWord = this.core.mem.readDataWord(61510)) >>> 7))) == 0)) {
            ki &= 0x7F;
        }
        this.core.mem.writeDataByte(61504, ki & 0xFF);
        if (this.holdS7) {
            this.core.mem.writeDataByte(61504, this.diagKI());
        }
    }

    public void checkButtonsEmu() {
        int emu_ki = 0;
        int emu_ko = 0;
        int i = 0;
        while (i < 56) {
            int y = i & 7;
            int x = i >>> 3;
            int bki = 1 << y;
            int bko = 1 << x;
            if (this.kb[i]) {
                if (!this.prev[i]) {
                    this.core.raiseInt(5);
                }
                emu_ki |= bki;
                emu_ko |= bko;
            }
            ++i;
        }
        if (this.canUpdateEmu(emu_ki, emu_ko)) {
            this.updateEmuKB(emu_ki, emu_ko);
        }
    }

    public boolean canUpdateEmu(int ki, int ko) {
        if (this.core.cfg.calcType == 257) {
            return true;
        }
        int status = Util.byteValue(this.core.mem.data[3584]);
        if (!Util.isEmuWait(status)) {
            return true;
        }
        if (Util.isEmuWait(status)) {
            return (ki | ko) != 0;
        }
        return true;
    }

    public void updateEmuKB(int emu_ki, int emu_ko) {
        if (this.core.cfg.calcType == 257) {
            this.core.mem.writeDataByte(59393, emu_ki & 0xFF);
            this.core.mem.writeDataByte(59394, emu_ko & 0xFF);
        } else {
            this.core.mem.writeDataByte(36353, emu_ki & 0xFF);
            this.core.mem.writeDataByte(36354, emu_ko & 0xFF);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
        ++this.frames;
        while (System.currentTimeMillis() >= this.lastTime + 1000L) {
            this.fpsString = String.valueOf(this.frames) + " fps";
            this.lastTime += 1000L;
            this.frames = 0;
        }
    }

    public void clearBuffer() {
        int[] mData = ((DataBufferInt)this.bufferedScreen.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < mData.length) {
            mData[i] = this.options.bgClr;
            ++i;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.options != null) {
            this.clearBuffer();
        }
        g.setColor(new Color(0xFFFFFF));
        if (this.cpu != null) {
            this.renderInfo();
            if (this.config.calcType == 257) {
                this.renderSevenSegment();
            } else if (this.config.calcType == 513) {
                this.renderTI();
            } else if (this.config.calcType == 5) {
                if (this.config.emuROM) {
                    this.renderCWIIEmu();
                } else {
                    this.renderCWII();
                }
            } else {
                this.renderVideoOutput(this.screen_res, this.screen_rows);
            }
        }
        if (this.scrnsht) {
            this.saveScreenshot();
            this.scrnsht = false;
        }
        this.getGraphics().drawImage(this.bufferedScreen, 0, 0, null);
    }

    public void saveScreenshot() {
        int[] data0 = ((DataBufferInt)this.bufferedScreen.getRaster().getDataBuffer()).getData();
        BufferedImage out = new BufferedImage(724, 584, 1);
        int[] data1 = ((DataBufferInt)out.getRaster().getDataBuffer()).getData();
        int iy = 0;
        while (iy < 584) {
            int ix = 0;
            while (ix < 724) {
                int indx0 = iy * 768 + ix;
                int indx1 = iy * 724 + ix;
                data1[indx1] = data0[indx0];
                ++ix;
            }
            ++iy;
        }
        String outname = "screenshot_" + System.currentTimeMillis() + ".png";
        File imgFile = new File(calcFolder, outname);
        try {
            ImageIO.write((RenderedImage)out, "png", imgFile);
            System.out.println("Saved screenshot as " + outname);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPC() {
        return "PC: 0x" + Util.shortToHex((short)this.cpu.reg_pc);
    }

    public String getCSR() {
        return "CSR: 0x" + Util.byteToHex(this.cpu.reg_csr);
    }

    public String getSP() {
        return "SP: 0x" + Util.shortToHex(this.cpu.reg_sp);
    }

    public String getEA() {
        return "EA: 0x" + Util.shortToHex(this.cpu.reg_ea);
    }

    public String getDSR() {
        return "DSR: 0x" + Util.byteToHex(this.cpu.adsr);
    }

    public String getLR() {
        return "LR: 0x" + Util.shortToHex((short)this.cpu.getLR());
    }

    public String getLCSR() {
        return "LCSR: 0x" + Util.byteToHex((byte)this.cpu.getLCSR());
    }

    public String getFlags() {
        return "FLAGS: " + Util.byteToBinary(this.cpu.reg_psw);
    }

    public String getR(int b) {
        return "R" + Util.HEX_ARRAY[b] + ": " + "0x" + Util.byteToHex((byte)this.cpu.getRegister(b));
    }

    public String getKIB() {
        return "KI: " + Util.byteToBinary(this.core.mem.data[28736]);
    }

    public void renderInfo() {
        Graphics g = this.bufferedScreen.getGraphics();
        g.drawString(this.fpsString, 6, 13);
        int offset0 = 496;
        g.drawString("Current State: ", offset0, 36);
        g.drawString(this.getFlags(), offset0, 54);
        g.drawString(this.getCSR(), offset0, 70);
        g.drawString(this.getPC(), offset0, 82);
        g.drawString(this.getLCSR(), offset0, 102);
        g.drawString(this.getLR(), offset0, 120);
        g.drawString(this.getSP(), offset0, 138);
        g.drawString(this.getDSR(), offset0, 156);
        g.drawString(this.getEA(), offset0, 174);
        g.drawString(this.getKIB(), 270, 180);
        if (this.pause) {
            g.drawString("PAUSED", 99, 180);
        }
        int offset1 = offset0 + 100;
        int i = 0;
        while (i < 16) {
            g.drawString(this.getR(i), offset1, 70 + 17 * i);
            ++i;
        }
    }

    public void renderSevenSegment() {
        BufferedImage img = new BufferedImage(64, 4, 1);
        int[] data = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int i2 = 0;
        DispSolarII disp = DispSolarII.instance;
        int i = 0;
        while (i < data.length) {
            int bIndx = i2 >>> 3;
            int subIndx = 7 ^ i2 & 7;
            int mask = 1 << subIndx;
            boolean on = (this.core.mem.readDataByte(63488 + bIndx) & mask) != 0;
            data[i] = on ? 65535 : 0;
            disp.bits[i] = on;
            ++i2;
            ++i;
        }
        Graphics g = this.bufferedScreen.getGraphics();
        g.drawImage(img, 16, 16, 384, 28, null);
        disp.renderOutput();
        g.drawImage(disp.output, 16, 56, 384, 64, null);
    }

    public void renderCWII() {
        int h = 64;
        int w = h * 3;
        int s = 1;
        BufferedImage img = new BufferedImage(w, 64, 1);
        int[] data = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int i2 = 0;
        int mask0 = (h << 2) - 1;
        int i = 0;
        while (i < data.length) {
            if ((i2 & mask0) == w) {
                i2 += h;
            }
            int bIndx = i2 >>> 3;
            int subIndx = 7 ^ i2 & 7;
            int mask = 1 << subIndx;
            boolean a = (this.core.disp_cwii.readByte2(bIndx) & mask) != 0;
            boolean b = (this.core.disp_cwii.readByte2(0x800 | bIndx) & mask) != 0;
            int clr = (a ? 1 : 0) | (b ? 2 : 0);
            data[i] = (clr ^ 3) * 0x555555;
            ++i2;
            ++i;
        }
        this.bufferedScreen.getGraphics().drawImage(img, 16, 16, w << s, 64 << s, null);
    }

    public void renderCWIIEmu() {
        int h = 64;
        int w = h * 3;
        int s = 1;
        BufferedImage img = new BufferedImage(w, 64, 1);
        int[] data = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int i2 = 0;
        int mask0 = (h << 2) - 1;
        int i = 0;
        while (i < data.length) {
            if ((i2 & mask0) == w) {
                i2 += h;
            }
            int bIndx = i2 >>> 3;
            int subIndx = 7 ^ i2 & 7;
            int mask = 1 << subIndx;
            boolean a = (this.core.mem.readDataByte(63488 + bIndx) & mask) != 0;
            boolean b = (this.core.mem.readDataByte(561152 + bIndx) & mask) != 0;
            int clr = (a ? 1 : 0) | (b ? 2 : 0);
            data[i] = (clr ^ 3) * 0x555555;
            ++i2;
            ++i;
        }
        this.bufferedScreen.getGraphics().drawImage(img, 16, 16, w << s, 64 << s, null);
    }

    public void renderVideoOutput(int res, int rows) {
        int h = 1 << res;
        int w = h * 3;
        int s = 7 - res;
        BufferedImage img = new BufferedImage(w, rows, 1);
        int[] data = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int i2 = 0;
        int mask0 = (h << 2) - 1;
        int i = 0;
        while (i < data.length) {
            if ((i2 & mask0) == w) {
                i2 += h;
            }
            int bIndx = i2 >>> 3;
            int subIndx = 7 ^ i2 & 7;
            int mask = 1 << subIndx;
            boolean on = (this.core.mem.readDataByte(63488 + bIndx) & mask) != 0;
            data[i] = on ? this.options.onClr : this.options.offClr;
            ++i2;
            ++i;
        }
        this.bufferedScreen.getGraphics().drawImage(img, 16, 16, w << s, rows << s, null);
    }

    public void renderTI() {
        BufferedImage img = new BufferedImage(192, 64, 1);
        int[] data = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int ix = 0;
        while (ix < 192) {
            int iy = 0;
            while (iy < 64) {
                int i = ix << 6 | iy;
                int bIndx = i >>> 3;
                int subIndx = i & 7;
                int mask = 1 << subIndx;
                boolean on = (this.core.mem.readDataByte(59144 + bIndx) & mask) != 0;
                data[iy * 192 + ix] = on ? 65535 : 0;
                ++iy;
            }
            ++ix;
        }
        this.bufferedScreen.getGraphics().drawImage(img, 16, 16, 384, 128, null);
    }

    public boolean isLetterDown(char k) {
        char key = k;
        return this.usrInptArr[key & 0xDF] > 0 || this.usrInptArr[key | 0x20] > 0;
    }

    public void clearLetter(char k) {
        char key = k;
        this.usrInptArr[key | 0x20] = 0;
        this.usrInptArr[key & 0xDF] = 0;
    }

    public void handleCrash(Throwable t, String msg) {
        t.printStackTrace();
        String crashfilename = "crash_" + System.currentTimeMillis() + ".txt";
        File crashFile = new File(calcFolder, crashfilename);
        try {
            FileWriter fileWriter = new FileWriter(crashFile);
            PrintWriter writer = new PrintWriter(fileWriter);
            System.out.println();
            this.crashPrintln(String.valueOf(msg) + "\n", writer);
            this.crashPrintln("Exception:", writer);
            this.crashPrintln(String.valueOf(t.toString()) + "\n", writer);
            this.crashPrintln("Stack Trace: ", writer);
            t.printStackTrace(System.out);
            t.printStackTrace(writer);
            this.crashPrintln("\nInfo:", writer);
            this.crashPrintln("BeuCalc Version: BeuCalc v0.6b5", writer);
            this.crashPrintln("Java Version: " + System.getProperty("java.version"), writer);
            this.crashPrintln("JVM: " + System.getProperty("java.vm.name"), writer);
            this.crashPrintln("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")", writer);
            this.crashPrintln("Config file: " + this.configfile, writer);
            if (this.config != null) {
                this.crashPrintln("CalcType: " + this.config.calcType, writer);
            }
            writer.close();
            System.out.println("\nSaved crash report to " + crashfilename);
        }
        catch (Throwable e) {
            System.err.println("Couldn't output crash report!!!");
            e.printStackTrace();
        }
    }

    public void crashPrintln(String s, PrintWriter fileout) {
        System.out.println(s);
        fileout.println(s);
    }

    @Override
    public boolean handleEvent(Event event) {
        int integer3 = 0;
        switch (event.id) {
            case 401: {
                integer3 = 1;
            }
            case 402: {
                this.usrInptArr[event.key & Short.MAX_VALUE] = integer3;
                break;
            }
            case 403: {
                integer3 = 1;
            }
            case 404: {
                this.usrInptArr[event.key & Short.MAX_VALUE] = integer3;
                break;
            }
            case 501: {
                integer3 = 1;
                this.mouseX = event.x - 0;
                this.mouseY = event.y - 0;
            }
            case 502: {
                if ((event.modifiers & 4) > 0) {
                    this.usrInptArr[1] = integer3;
                    break;
                }
                this.usrInptArr[0] = integer3;
                break;
            }
            case 503: 
            case 506: {
                this.mouseX = event.x - 0;
                this.mouseY = event.y - 0;
                break;
            }
        }
        return true;
    }

    public static void spawn(String cfg) {
        Frame frame = new Frame();
        frame.setSize(744, 640);
        BeuCalc tst = new BeuCalc();
        frame.add(tst);
        frame.setBackground(Color.BLUE);
        frame.setVisible(true);
        frame.setTitle("BeuCalc v0.6b5");
        frame.addWindowListener(tst);
        tst.configfile = cfg;
        tst.startEmu();
    }

    public static void main(String[] args) {
        String cfgpath = null;
        try {
            cfgpath = args[0];
        }
        catch (Throwable t) {
            System.out.println("Using default config (configs/fx570esplus.txt)");
            cfgpath = "configs/fx570esplus.txt";
        }
        BeuCalc.spawn(cfgpath);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.stopEmu();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

