/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.beucalc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.enderkitty.beucalc.BeuCalc;
import net.enderkitty.beucalc.KeyCodes;
import net.enderkitty.beucalc.Util;

public class Config {
    public static final int TYPE_2S = 2;
    public static final int TYPE_ES = 3;
    public static final int TYPE_CW_X = 4;
    public static final int TYPE_CWII = 5;
    public static final int TYPE_CWFUTURE = 6;
    public static final int TYPE_SOLARII = 257;
    public static final int TYPE_2LINE = 258;
    public static final int TYPE_FX5800P = 259;
    public static final int TYPE_TI_MATHPRINT = 513;
    public int calcType;
    public String romfile;
    public String flashfile;
    public String kbFile;
    public int kc;
    public boolean emuROM;
    public boolean noCSR;
    public boolean legacyKO;
    public int csrMask;
    public int pd;
    public int tps;
    public String[] kbLabel;

    public void loadKB() {
        System.out.println("KB: " + this.kbFile);
        this.loadKBFromFile(new File(BeuCalc.calcFolder, this.kbFile));
    }

    public void loadKBFromRom(byte[] rom) {
        this.kbLabel = new String[56];
        KeyCodes.createArrayB();
        int ki = 0;
        while (ki < 8) {
            int ko = 0;
            while (ko < 7) {
                int offset = ki << 3 | ko;
                int addr = Util.shortValue(this.kc + offset);
                int id = Util.byteValue(rom[addr]);
                if (id != 0) {
                    int indx;
                    KeyCodes.kcButtons[id] = indx = ko << 3 | ki;
                    this.kbLabel[indx] = KeyCodes.keycodes[id] != null ? KeyCodes.keycodes[id] : String.valueOf(Util.byteToHex((byte)id)) + "?";
                }
                ++ko;
            }
            ++ki;
        }
    }

    public void initButtonKeys() {
        int i = 0;
        while (i < 10) {
            int val = 0x30 | i;
            BeuCalc.kbchar[val] = KeyCodes.kcButtons[val];
            ++i;
        }
        BeuCalc.kbchar[Util.charToByte((char)'%')] = KeyCodes.kcButtons[37];
        BeuCalc.kbchar[Util.charToByte((char)'(')] = KeyCodes.kcButtons[40];
        BeuCalc.kbchar[Util.charToByte((char)')')] = KeyCodes.kcButtons[41];
        BeuCalc.kbchar[Util.charToByte((char)'+')] = KeyCodes.kcButtons[43];
        BeuCalc.kbchar[Util.charToByte((char)',')] = KeyCodes.kcButtons[44];
        BeuCalc.kbchar[Util.charToByte((char)'-')] = KeyCodes.kcButtons[45];
        BeuCalc.kbchar[Util.charToByte((char)'.')] = KeyCodes.kcButtons[46];
        BeuCalc.kbchar[Util.charToByte((char)':')] = KeyCodes.kcButtons[58];
        BeuCalc.kbchar[Util.charToByte((char)'=')] = KeyCodes.kcButtons[61];
        BeuCalc.kbchar[Util.charToByte((char)'*')] = KeyCodes.kcButtons[78];
        BeuCalc.kbchar[Util.charToByte((char)'/')] = KeyCodes.kcButtons[79];
        BeuCalc.kbchar[Util.charToByte((char)'!')] = KeyCodes.kcButtons[87];
        BeuCalc.kbchar[Util.charToByte((char)'^')] = KeyCodes.kcButtons[210];
        BeuCalc.kbchar[27] = KeyCodes.kcButtons[230];
        BeuCalc.kbchar[10] = KeyCodes.kcButtons[240];
        BeuCalc.kbchar[8] = KeyCodes.kcButtons[254];
    }

    public void loadKBFromFile(File file) {
        this.kbLabel = new String[56];
        try {
            if (file.exists()) {
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String s = null;
                while ((s = bufferedReader.readLine()) != null) {
                    String label;
                    if (s.length() == 0 || s.startsWith("#")) continue;
                    int indx = Integer.parseInt(s.substring(0, 3), 8);
                    this.kbLabel[indx] = label = s.substring(4);
                }
                bufferedReader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveKB(String[] kb, File configFile) {
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            PrintWriter writer = new PrintWriter(fileWriter);
            int ki = 0;
            while (ki < 8) {
                int ko = 0;
                while (ko < 7) {
                    int id = ko << 3 | ki;
                    if (kb[id] != null) {
                        writer.println(String.valueOf(Util.byteToOctal((byte)id)) + ":" + kb[id]);
                    }
                    ++ko;
                }
                writer.println();
                ++ki;
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Config loadConfig(File file) {
        Config cfg = new Config();
        cfg.csrMask = -1;
        cfg.noCSR = false;
        String kcFile = null;
        try {
            if (file.exists()) {
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String s = null;
                while ((s = bufferedReader.readLine()) != null) {
                    if (s.length() == 0 || s.startsWith("#")) continue;
                    String[] st = s.split(":");
                    if (st[0].equalsIgnoreCase("type")) {
                        cfg.calcType = Integer.decode(st[1]);
                    }
                    if (st[0].equalsIgnoreCase("romfile")) {
                        cfg.romfile = st[1];
                    }
                    if (st[0].equalsIgnoreCase("flashfile")) {
                        cfg.flashfile = st[1];
                    }
                    if (st[0].equalsIgnoreCase("kbFile")) {
                        cfg.kbFile = st[1];
                    }
                    if (st[0].equalsIgnoreCase("kcFile")) {
                        kcFile = st[1];
                    }
                    if (st[0].equalsIgnoreCase("keyOffset")) {
                        cfg.kc = Integer.decode(st[1]);
                    }
                    if (st[0].equalsIgnoreCase("emulator")) {
                        cfg.emuROM = st[1].equalsIgnoreCase("true");
                    }
                    if (st[0].equalsIgnoreCase("noCSR")) {
                        cfg.noCSR = st[1].equalsIgnoreCase("true");
                    }
                    if (st[0].equalsIgnoreCase("legacyKO")) {
                        cfg.legacyKO = st[1].equalsIgnoreCase("true");
                    }
                    if (st[0].equalsIgnoreCase("csrMask")) {
                        cfg.csrMask = Integer.decode(st[1]);
                    }
                    if (st[0].equalsIgnoreCase("pd")) {
                        cfg.pd = Integer.parseInt(st[1]);
                    }
                    if (!st[0].equalsIgnoreCase("tps")) continue;
                    cfg.tps = Integer.parseInt(st[1]);
                }
                bufferedReader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (kcFile != null) {
            KeyCodes.loadKC(kcFile);
        }
        return cfg;
    }

    public static Config sampleConfig() {
        Config cfg = new Config();
        cfg.calcType = 3;
        cfg.romfile = "roms/gy454xe.bin";
        cfg.kbFile = "kb/fx570esp.txt";
        cfg.emuROM = false;
        cfg.pd = -1;
        cfg.tps = -1;
        return cfg;
    }

    public static void saveConfig(Config cfg, File configFile) {
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            PrintWriter writer = new PrintWriter(fileWriter);
            writer.println("type:" + cfg.calcType);
            writer.println("romfile:" + cfg.romfile);
            writer.println("kbFile:" + cfg.kbFile);
            writer.println("emulator:" + cfg.emuROM);
            writer.println("csrMask:" + cfg.csrMask);
            writer.println("pd:" + cfg.pd);
            writer.println("tps:" + cfg.tps);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isTypeValid(int calcType) {
        if (calcType == 257 || calcType == 259) {
            return true;
        }
        if (calcType == 513) {
            return true;
        }
        return calcType > 1 && calcType < 6;
    }

    public static boolean isTypeMain(int calcType) {
        return calcType > 1 && calcType < 7;
    }

    public static int getDefaultCSR_MASK(int calcType) {
        if (calcType == 2) {
            return 0;
        }
        if (calcType == 257) {
            return 0;
        }
        if (calcType == 3) {
            return 1;
        }
        return 15;
    }

    public static boolean isTypeClasswiz(int calcType) {
        return calcType > 3 && calcType < 8;
    }
}

