/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.beucalc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.enderkitty.beucalc.Util;

public class Options {
    public int bgClr = 255;
    public int fgClr = 0xFFFFFF;
    public int offClr = 0;
    public int onClr = 65535;

    public static Options loadOptions(File file) {
        Options op = new Options();
        try {
            if (file.exists()) {
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String s = null;
                while ((s = bufferedReader.readLine()) != null) {
                    if (s.length() == 0 || s.startsWith("#")) continue;
                    String[] st = s.split(":");
                    if (st[0].equalsIgnoreCase("bgClr")) {
                        op.bgClr = Integer.decode(st[1]);
                    }
                    if (st[0].equalsIgnoreCase("fgClr")) {
                        op.fgClr = Integer.decode(st[1]);
                    }
                    if (st[0].equalsIgnoreCase("offClr")) {
                        op.offClr = Integer.decode(st[1]);
                    }
                    if (!st[0].equalsIgnoreCase("onClr")) continue;
                    op.onClr = Integer.decode(st[1]);
                }
                bufferedReader.close();
            } else {
                System.out.println("saving default options");
                Options.saveOptions(op, file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return op;
    }

    public static void saveOptions(Options opt, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter writer = new PrintWriter(fileWriter);
            writer.println("bgClr:0x" + Util.rgbToHex(opt.bgClr));
            writer.println("fgClr:0x" + Util.rgbToHex(opt.fgClr));
            writer.println("offClr:0x" + Util.rgbToHex(opt.offClr));
            writer.println("onClr:0x" + Util.rgbToHex(opt.onClr));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

