/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.beucalc;

public class Timer {
    private static final long NS_PER_SECOND = 1000000000L;
    private static final long MAX_NS_PER_UPDATE = 1000000000L;
    private static final int MAX_TICKS_PER_UPDATE = 100;
    private double ticksPerSecond;
    private long lastTime;
    public int ticks;
    public double a;
    public double timeScale = 1.0;
    public double passedTime = 0.0;

    public Timer(double ticksPerSecond) {
        this.ticksPerSecond = ticksPerSecond;
        this.lastTime = System.nanoTime();
    }

    public void advanceTime() {
        long now = System.nanoTime();
        long passedNs = now - this.lastTime;
        this.lastTime = now;
        if (passedNs < 0L) {
            passedNs = 0L;
        }
        if (passedNs > 1000000000L) {
            passedNs = 1000000000L;
        }
        this.passedTime += (double)passedNs * this.timeScale * this.ticksPerSecond / 1.0E9;
        this.ticks = (int)this.passedTime;
        if (this.ticks > 100) {
            this.ticks = 100;
        }
        this.passedTime -= (double)this.ticks;
        this.a = this.passedTime;
    }
}

