/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.beucalc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Util {
    public static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static void saveBin(String fName, byte[] data) {
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(new File(fName)));
            dos.write(data);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] loadBin(File f, int length) {
        int size = length;
        byte[] data = new byte[size];
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(f));
            dis.readFully(data);
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public static int byteValue(int in) {
        return in & 0xFF & 0xFF;
    }

    public static int shortValue(int in) {
        return in & 0xFFFF;
    }

    public static int align(int in) {
        return in & 0xFFFFFFFE;
    }

    public static int altValue(int in) {
        return in & Integer.MAX_VALUE;
    }

    public static int charToByte(char c) {
        return Util.byteValue(c);
    }

    public static String byteToHex(int bytes) {
        char[] hexChars = new char[2];
        int v = bytes & 0xFF;
        hexChars[0] = HEX_ARRAY[v >>> 4];
        hexChars[1] = HEX_ARRAY[v & 0xF];
        return new String(hexChars);
    }

    public static String shortToHex(int bytes) {
        char[] hexChars = new char[4];
        int v = bytes & 0xFFFF;
        hexChars[0] = HEX_ARRAY[v >>> 12];
        hexChars[1] = HEX_ARRAY[v >>> 8 & 0xF];
        hexChars[2] = HEX_ARRAY[v >>> 4 & 0xF];
        hexChars[3] = HEX_ARRAY[v & 0xF];
        return new String(hexChars);
    }

    public static String intToHex(int bytes) {
        char[] hexChars = new char[8];
        int v = bytes & 0xFFFFFFFF;
        hexChars[0] = HEX_ARRAY[v >>> 28];
        hexChars[1] = HEX_ARRAY[v >>> 24 & 0xF];
        hexChars[2] = HEX_ARRAY[v >>> 20 & 0xF];
        hexChars[3] = HEX_ARRAY[v >>> 16 & 0xF];
        hexChars[4] = HEX_ARRAY[v >>> 12 & 0xF];
        hexChars[5] = HEX_ARRAY[v >>> 8 & 0xF];
        hexChars[6] = HEX_ARRAY[v >>> 4 & 0xF];
        hexChars[7] = HEX_ARRAY[v & 0xF];
        return new String(hexChars);
    }

    public static String rgbToHex(int bytes) {
        char[] hexChars = new char[6];
        int v = bytes & 0xFFFFFF;
        hexChars[0] = HEX_ARRAY[v >>> 20];
        hexChars[1] = HEX_ARRAY[v >>> 16 & 0xF];
        hexChars[2] = HEX_ARRAY[v >>> 12 & 0xF];
        hexChars[3] = HEX_ARRAY[v >>> 8 & 0xF];
        hexChars[4] = HEX_ARRAY[v >>> 4 & 0xF];
        hexChars[5] = HEX_ARRAY[v & 0xF];
        return new String(hexChars);
    }

    public static String byteToBinary(byte bytes) {
        char[] hexChars = new char[8];
        int v = bytes & 0xFF;
        int i = 0;
        while (i < 8) {
            hexChars[7 ^ i] = (char)(0x30 | v >>> i & 1);
            ++i;
        }
        return new String(hexChars);
    }

    public static String byteToOctal(byte bytes) {
        char[] hexChars = new char[3];
        int v = bytes & 0xFF;
        hexChars[0] = HEX_ARRAY[v >>> 6 & 7];
        hexChars[1] = HEX_ARRAY[v >>> 3 & 7];
        hexChars[2] = HEX_ARRAY[v & 7];
        return new String(hexChars);
    }

    public static boolean isEmuWait(int emu_status) {
        return (emu_status & 0xE) != 0 && (emu_status & 1) == 0;
    }
}

