/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.beucalc.core;

import net.enderkitty.beucalc.Config;
import net.enderkitty.beucalc.DispCWII;
import net.enderkitty.beucalc.Util;
import net.enderkitty.beucalc.core.Emulator;
import net.enderkitty.beucalc.core.Memory;
import net.enderkitty.beucalc.core.Processor;
import net.enderkitty.beucalc.core.SFRTimer;

public class Core {
    public static final int INT_RESET = 1;
    public Emulator emu;
    public Config cfg;
    public SFRTimer tmr;
    public Processor cpu;
    public Memory mem;
    public DispCWII disp_cwii;
    public byte[] rom_data;
    public boolean run;
    public boolean[] interrupts;

    public Core(Emulator e) {
        this.emu = e;
        this.cfg = e.getEmuCfg();
        this.tmr = new SFRTimer(this);
        if (this.cfg.calcType == 5) {
            this.disp_cwii = new DispCWII(this);
        }
        this.mem = new Memory(this, e.getEmuCfg());
        this.interrupts = new boolean[64];
    }

    public void setRomData(byte[] p) {
        this.rom_data = p;
        int size = p.length;
        System.out.println("ROM SIZE is " + size);
        System.out.println("INITIAL SP is 0x" + Util.shortToHex((short)this.mem.readCode(0)));
        System.out.println("START ADDR is 0x" + Util.shortToHex((short)this.mem.readCode(2)));
    }

    public void on() {
        this.run = true;
        this.cpu.raise(0, 1);
        this.cpu.reg_sp = (short)this.mem.readCode(0);
    }

    public void resetSP() {
        this.cpu.reg_sp = (short)this.mem.readCode(0);
    }

    public boolean isClasswiz() {
        return this.cfg.calcType > 3 && this.cfg.calcType < 8;
    }

    public void clearRam() {
        int i = 0;
        while (i < this.mem.data.length) {
            this.mem.data[i] = 0;
            ++i;
        }
        if (this.cfg.calcType == 5) {
            i = 0;
            while (i < this.mem.cwiiram.length) {
                this.mem.cwiiram[i] = 0;
                ++i;
            }
        }
        if (this.cfg.calcType == 259) {
            i = 0;
            while (i < this.mem.pram.length) {
                this.mem.pram[i] = 0;
                ++i;
            }
        }
    }

    public int getCSR_MASK() {
        if (this.isClasswiz()) {
            return 15;
        }
        return 1;
    }

    public void reset() {
        this.cpu.reset();
    }

    public void tick() {
        this.tickInts();
        if (this.run) {
            this.cpu.tick();
        }
    }

    public void raiseInt(int indx) {
        this.interrupts[indx] = true;
    }

    public int getIMask() {
        return this.mem.readDataWord(61456);
    }

    public void addPending(int indx) {
        int bit = 1 << indx - 4;
        int pending = this.mem.readDataWord(61460);
        this.mem.writeDataWord(61460, pending | bit);
    }

    public boolean intEnabled(int indx) {
        if (indx < 5) {
            return true;
        }
        int bit = 1 << indx - 4;
        return (this.getIMask() & bit) != 0;
    }

    public void emuKBInt() {
        int ko;
        int ki;
        int status = Util.byteValue(this.mem.data[3584]);
        if (Util.isEmuWait(status) && !this.emu.isEmuACDown(ki = Util.byteValue(this.mem.data[3585]), ko = Util.byteValue(this.mem.data[3586]))) {
            this.mem.writeDataByte(36352, status & 1);
        }
    }

    public void emuKBCheck() {
        int status = Util.byteValue(this.mem.data[3584]);
        if (Util.isEmuWait(status)) {
            int ko;
            int ki = Util.byteValue(this.mem.data[3585]);
            if (!this.emu.isEmuACDown(ki, ko = Util.byteValue(this.mem.data[3586]))) {
                this.mem.writeDataByte(36352, status & 1);
            }
            this.run = true;
        }
    }

    public void tickInts() {
        boolean check = false;
        int i = 0;
        while (i < this.interrupts.length) {
            if (this.interrupts[i]) {
                check = true;
            }
            ++i;
        }
        if (check) {
            int intindx = 0;
            int elvl = 0;
            if (this.interrupts[1]) {
                intindx = 1;
                elvl = 0;
            } else {
                int i2 = 5;
                while (i2 < 64) {
                    if (this.interrupts[i2]) {
                        intindx = i2;
                        elvl = 1;
                    }
                    ++i2;
                }
            }
            if (this.cfg.emuROM && intindx > 4) {
                this.emuKBInt();
            }
            if (this.intEnabled(intindx)) {
                this.addPending(intindx);
                if (intindx < 5) {
                    this.cpu.raise(elvl, intindx);
                }
            }
            this.interrupts[intindx] = false;
            this.run = true;
        } else if (!this.run && this.cfg.emuROM) {
            this.emuKBCheck();
        }
    }
}

