/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.beucalc.core;

import net.enderkitty.beucalc.Config;
import net.enderkitty.beucalc.Util;
import net.enderkitty.beucalc.core.Core;

public class Memory {
    public static boolean allowLog;
    public Core core;
    public byte[] data;
    public byte[] flash;
    public byte[] pram;
    public byte[] cwiiram;

    public Memory(Core c, Config cfg) {
        this.core = c;
        this.data = new byte[32768];
        if (Config.isTypeClasswiz(cfg.calcType)) {
            this.cwiiram = new byte[32768];
        }
        if (cfg.calcType == 259) {
            this.pram = new byte[32768];
            this.flash = new byte[524288];
        }
        this.data[4092] = -52;
        this.data[4093] = -35;
        this.data[4094] = -18;
        this.data[4095] = -1;
    }

    public int readCode(int offset) {
        int addr;
        int seg = offset >>> 16 & Util.byteValue(this.core.cfg.csrMask);
        int indx = seg << 16 | (addr = offset & 0xFFFE);
        if (indx < this.core.rom_data.length) {
            return Util.byteValue(this.core.rom_data[indx | 1]) << 8 | Util.byteValue(this.core.rom_data[indx]);
        }
        System.out.println("unknown code segment: 0x" + Util.byteToHex(seg));
        this.core.emu.setPause(true);
        return 52991;
    }

    public int readDataByte(int offset) {
        int part;
        int pd;
        int seg = offset >>> 16;
        int addr = offset & 0xFFFF;
        if (seg == 0 && addr == 61520 && (pd = this.core.cfg.pd) > -1) {
            if (this.core.cfg.legacyKO) {
                return Util.byteValue(1 << (pd & 0xF));
            }
            if (this.core.cfg.emuROM || this.core.isClasswiz()) {
                return Util.byteValue(pd);
            }
        }
        if (this.core.cfg.calcType == 513) {
            if (seg == 0) {
                if (addr == 61454) {
                    return Util.byteValue(this.data[addr & Short.MAX_VALUE]) | 1;
                }
                if (addr >= 45056) {
                    return Util.byteValue(this.data[addr & Short.MAX_VALUE]);
                }
                return Util.byteValue(this.core.rom_data[addr]);
            }
            if (seg == 1) {
                return Util.byteValue(this.core.rom_data[0x10000 | addr]);
            }
            if (seg == 2) {
                return Util.byteValue(this.core.rom_data[0x20000 | addr]);
            }
            if (seg == 3) {
                return Util.byteValue(this.core.rom_data[0x30000 | addr]);
            }
        }
        if (this.core.cfg.calcType == 257 && seg == 0) {
            if (addr >= 57344) {
                return Util.byteValue(this.data[addr & Short.MAX_VALUE]);
            }
            return Util.byteValue(this.core.rom_data[addr]);
        }
        if (this.core.cfg.calcType == 5) {
            if (seg == 0) {
                if (addr == 62480) {
                    return 0x80 | Util.byteValue(this.data[addr & Short.MAX_VALUE]);
                }
                if (addr == 62635) {
                    return 240;
                }
                if (!this.core.cfg.emuROM && (addr & 0xF800) == 63488) {
                    return this.core.disp_cwii.readByte(addr & 0x7FF);
                }
                if (addr >= 36864) {
                    return Util.byteValue(this.data[addr & Short.MAX_VALUE]);
                }
            }
            if (!this.core.cfg.emuROM) {
                part = seg << 16;
                return Util.byteValue(this.core.rom_data[(part | addr) & 0x7FFFF]);
            }
            if (seg == 8) {
                if (addr >= 32768) {
                    if (addr < 36864) {
                        return Util.byteValue(this.data[addr & Short.MAX_VALUE]);
                    }
                    return Util.byteValue(this.cwiiram[addr & Short.MAX_VALUE]);
                }
                return Util.byteValue(this.core.rom_data[addr]);
            }
            part = seg << 16;
            return Util.byteValue(this.core.rom_data[(part | addr) & 0x7FFFF]);
        }
        if (this.core.cfg.calcType == 4) {
            if (seg == 0 && addr >= 53248) {
                return Util.byteValue(this.data[addr & Short.MAX_VALUE]);
            }
            if (seg == 4 && addr >= 32768) {
                return Util.byteValue(this.data[addr & Short.MAX_VALUE]);
            }
            if (seg == 5) {
                return Util.byteValue(this.core.rom_data[addr]);
            }
            part = seg << 16;
            return Util.byteValue(this.core.rom_data[(part | addr) & 0x3FFFF]);
        }
        if (this.core.cfg.calcType == 259) {
            if ((seg & 8) != 0) {
                part = (seg & 7) << 16;
                return Util.byteValue(this.flash[part | addr]);
            }
            if (seg == 4 && (addr & 0x8000) == 0) {
                return Util.byteValue(this.pram[addr]);
            }
            if (seg == 0 && addr == 61510) {
                return Util.byteValue(this.data[addr & Short.MAX_VALUE]) | 4;
            }
        }
        if (seg == 0) {
            if ((addr & 0x8000) == 0) {
                return Util.byteValue(this.core.rom_data[addr]);
            }
            return Util.byteValue(this.data[addr & Short.MAX_VALUE]);
        }
        if (seg == 1) {
            return Util.byteValue(this.core.rom_data[0x10000 | addr]);
        }
        if (seg == 8) {
            return Util.byteValue(this.core.rom_data[addr]);
        }
        return 0;
    }

    public int readDataWord(int offset) {
        int waddr = Util.align(offset);
        return Util.byteValue(this.readDataByte(waddr | 1)) << 8 | Util.byteValue(this.readDataByte(waddr));
    }

    public int readDataXR(int addr) {
        int p0 = this.readDataWord(addr + 2) << 16;
        int p2 = this.readDataWord(addr);
        return p0 | p2;
    }

    public boolean canWriteHere(int addr) {
        if (this.core.cfg.calcType == 3 && !this.core.cfg.emuROM) {
            return (addr & 0xFE00) != 36352;
        }
        return true;
    }

    public void writeDataByte(int offset, int data) {
        int seg = offset >>> 16;
        int addr = offset & 0xFFFF;
        data = Util.byteValue(data);
        if (this.core.cfg.calcType == 5) {
            if (seg == 0 && (addr & 0xF800) == 63488) {
                this.core.disp_cwii.writeByte(addr & 0x7FF, data);
            }
            if (seg == 8 && (addr & 0x8000) != 0) {
                if (addr < 36864) {
                    this.data[addr & Short.MAX_VALUE] = (byte)Util.byteValue(data);
                } else {
                    this.cwiiram[addr & Short.MAX_VALUE] = (byte)Util.byteValue(data);
                }
            }
        }
        if (this.core.cfg.calcType == 4 && seg == 4 && addr >= 32768) {
            this.data[addr & Short.MAX_VALUE] = (byte)Util.byteValue(data);
        }
        if (this.core.cfg.calcType == 259) {
            if (seg == 4 && (addr & 0x8000) == 0) {
                this.pram[addr] = (byte)Util.byteValue(data);
            }
            if ((seg & 8) != 0) {
                int n = (seg & 7) << 16;
            }
        }
        if (seg == 0) {
            if (addr == 61440) {
                this.core.cpu.reg_dsr = (byte)Util.byteValue(data);
            }
            if (addr == 61449 && (data & 3) != 0) {
                this.core.run = false;
            }
            if ((addr & 0x8000) != 0 && this.canWriteHere(addr)) {
                this.data[addr & Short.MAX_VALUE] = (byte)Util.byteValue(data);
            }
            if (this.core.cfg.calcType == 513 && addr == 63745) {
                this.data[30977] = (byte)Util.byteValue(data ^ 1);
            }
        }
    }

    public void writeDataWord(int addr, int val) {
        int waddr = Util.align(addr);
        this.writeDataByte(waddr, val);
        this.writeDataByte(waddr | 1, val >>> 8);
    }

    public void writeDataXR(int addr, int val) {
        this.writeDataWord(addr, Util.shortValue(val));
        this.writeDataWord(addr + 2, Util.shortValue(val >>> 16));
    }

    public int popByteFromStack() {
        int value = this.readDataByte(this.core.cpu.getSP());
        this.core.cpu.reg_sp = (short)(this.core.cpu.reg_sp + 2);
        return value;
    }

    public int popWordFromStack() {
        int value = this.readDataWord(this.core.cpu.getSP());
        this.core.cpu.reg_sp = (short)(this.core.cpu.reg_sp + 2);
        return value;
    }

    public int popIntFromStack() {
        int value = this.readDataXR(this.core.cpu.getSP());
        this.core.cpu.reg_sp = (short)(this.core.cpu.reg_sp + 4);
        return value;
    }

    public void pushByteToStack(int val) {
        this.core.cpu.reg_sp = (short)(this.core.cpu.reg_sp - 2);
        this.writeDataByte(this.core.cpu.getSP(), val);
    }

    public void pushIntToStack(int val) {
        this.core.cpu.reg_sp = (short)(this.core.cpu.reg_sp - 4);
        this.writeDataXR(this.core.cpu.getSP(), val);
    }

    public void pushWordToStack(int val) {
        this.core.cpu.reg_sp = (short)(this.core.cpu.reg_sp - 2);
        this.writeDataWord(this.core.cpu.getSP(), val);
    }

    public void printRead(int addr) {
        if (allowLog) {
            int seg = addr >>> 16;
            int offset = addr & 0xFFFF;
            System.out.println("Read from " + Util.byteToHex(seg) + ":" + Util.shortToHex(offset) + "h");
        }
    }

    public void printWrite(int addr, int val) {
        if (allowLog) {
            int seg = addr >>> 16;
            int offset = addr & 0xFFFF;
            int dat = Util.byteValue(val);
            System.out.println("Write 0x" + Util.byteToHex(dat) + "h to " + Util.byteToHex(seg) + ":" + Util.shortToHex(offset) + "h");
        }
    }
}

