/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.beucalc.core;

import net.enderkitty.beucalc.Util;
import net.enderkitty.beucalc.core.Core;

public class Processor {
    public static final boolean PRINT_PC = false;
    public static final boolean PRINT_SP = false;
    public static final boolean PRINT_REG = false;
    public static final int PSW_C = 128;
    public static final int PSW_Z = 64;
    public static final int PSW_S = 32;
    public static final int PSW_OV = 16;
    public static final int PSW_MIE = 8;
    public static final int PSW_HC = 4;
    public Core core;
    public boolean hasCSR;
    public int reg_pc;
    public short[] reg_elr;
    public byte reg_csr;
    public byte[] reg_ecsr;
    public byte reg_psw;
    public byte[] reg_epsw;
    public short reg_sp;
    public short reg_ea;
    public byte reg_dsr;
    public boolean dsr;
    public byte adsr;
    public int prev_pc;
    public byte[] registers;

    public Processor(Core c) {
        c.cpu = this;
        this.core = c;
        this.setELVL(0);
        this.hasCSR = true;
        this.reg_elr = new short[4];
        this.reg_ecsr = new byte[4];
        this.reg_epsw = new byte[4];
        this.registers = new byte[16];
    }

    public int getRegister(int r) {
        return Util.byteValue(this.registers[r]);
    }

    public void setLR(int val) {
        this.reg_elr[0] = (short)Util.shortValue(val);
    }

    public int getLR() {
        return Util.shortValue(this.reg_elr[0]);
    }

    public void setLCSR(int val) {
        this.reg_ecsr[0] = (byte)Util.byteValue(val & 0xF);
    }

    public int getLCSR() {
        return Util.byteValue(this.reg_ecsr[0]);
    }

    public int getELVL() {
        return Util.byteValue(this.reg_psw) & 3;
    }

    public void setELVL(int val) {
        int psw = Util.byteValue(this.reg_psw) & 0xFE;
        int elvl = val & 3;
        this.reg_psw = (byte)Util.byteValue(psw | elvl);
    }

    public void setRegister(int r, int val) {
        this.registers[r] = (byte)val;
    }

    public void loadRegister(int r, int val) {
        this.setRegister(r, val);
        this.PSW_SETBOOL(64, Util.byteValue(val) == 0);
        this.PSW_SETBOOL(32, (Util.byteValue(val) & 0x80) != 0);
    }

    public int getERn(int r) {
        int a = Util.byteValue(this.getRegister(r &= 0x1E));
        int b = Util.byteValue(this.getRegister(r + 1));
        return Util.shortValue(b << 8 | a);
    }

    public int getBP() {
        return this.getERn(12);
    }

    public int getSP() {
        return Util.shortValue(this.reg_sp);
    }

    public int getFP() {
        return this.getERn(14);
    }

    public int getXRn(int r) {
        int a = Util.byteValue(this.getRegister(r &= 0x1C));
        int b = Util.byteValue(this.getRegister(r + 1)) << 8;
        int c = Util.byteValue(this.getRegister(r + 2)) << 16;
        int d = Util.byteValue(this.getRegister(r + 3)) << 24;
        return d | c | b | a;
    }

    public void setERn(int r, int val) {
        val = Util.shortValue(val);
        this.setRegister(r &= 0x1E, val & 0xFF);
        this.setRegister(r + 1, (val & 0xFF00) >>> 8);
    }

    public void loadERn(int r, int val) {
        this.setERn(r, val);
        this.PSW_SETBOOL(64, Util.shortValue(val) == 0);
        this.PSW_SETBOOL(32, (Util.shortValue(val) & 0x8000) != 0);
    }

    public void setXRn(int r, int val) {
        this.setRegister(r &= 0x1C, val);
        this.setRegister(r + 1, val >>> 8);
        this.setRegister(r + 2, val >>> 16);
        this.setRegister(r + 3, val >>> 24);
    }

    public void loadXRn(int r, int val) {
        this.setXRn(r, val);
        this.PSW_SETBOOL(64, val == 0);
        this.PSW_SETBOOL(32, (val & Integer.MIN_VALUE) != 0);
    }

    public int fetch() {
        this.reg_pc = Util.shortValue(this.reg_pc & 0xFFFE);
        int opcode = this.core.mem.readCode(Util.byteValue(this.reg_csr) << 16 | Util.shortValue(this.reg_pc));
        this.reg_pc = Util.shortValue(this.reg_pc + 2);
        return opcode;
    }

    public void incEA(int b) {
        this.reg_ea = (short)(this.reg_ea + b);
        int mask = 0xFFFFE | b & 1;
        this.reg_ea = (short)Util.shortValue(this.reg_ea & mask);
    }

    public int fetchDataByte(boolean inc) {
        int dat = this.core.mem.readDataByte(Util.byteValue(this.adsr) << 16 | Util.shortValue(this.reg_ea));
        if (inc) {
            this.incEA(1);
        }
        return dat;
    }

    public int fetchDataShort(boolean inc) {
        int dat = this.core.mem.readDataWord(Util.byteValue(this.adsr) << 16 | Util.shortValue(this.reg_ea));
        if (inc) {
            this.incEA(2);
        }
        return dat;
    }

    public int fetchDataInt(boolean inc) {
        int dat = this.core.mem.readDataXR(Util.byteValue(this.adsr) << 16 | Util.shortValue(this.reg_ea));
        if (inc) {
            this.incEA(4);
        }
        return dat;
    }

    public void fetchDataQR(int r, boolean inc) {
        int addr = Util.byteValue(this.adsr) << 16 | Util.shortValue(this.reg_ea);
        int a = this.core.mem.readDataXR(addr);
        int b = this.core.mem.readDataXR(addr + 4);
        this.setXRn(r, a);
        this.setXRn(r + 4, b);
        this.PSW_SETBOOL(64, (a | b) == 0);
        if (inc) {
            this.incEA(8);
        }
    }

    public void dropDataByte(int val, boolean inc) {
        int addr = Util.byteValue(this.adsr) << 16 | Util.shortValue(this.reg_ea);
        this.core.mem.writeDataByte(addr, val);
        if (inc) {
            this.incEA(1);
        }
    }

    public void dropDataShort(int val, boolean inc) {
        int addr = Util.byteValue(this.adsr) << 16 | Util.shortValue(this.reg_ea);
        this.core.mem.writeDataWord(addr, val);
        if (inc) {
            this.incEA(2);
        }
    }

    public void dropDataInt(int val, boolean inc) {
        int addr = Util.byteValue(this.adsr) << 16 | Util.shortValue(this.reg_ea);
        this.core.mem.writeDataXR(addr, val);
        if (inc) {
            this.incEA(4);
        }
    }

    public void dropDataQR(int r, boolean inc) {
        int addr = Util.byteValue(this.adsr) << 16 | Util.shortValue(this.reg_ea);
        int a = this.getXRn(r);
        int b = this.getXRn(r + 4);
        this.core.mem.writeDataXR(addr, a);
        this.core.mem.writeDataXR(addr + 4, b);
        if (inc) {
            this.incEA(8);
        }
    }

    public int seg(int addr) {
        return Util.byteValue(this.adsr) << 16 | Util.shortValue(addr);
    }

    public void tick() {
        this.prev_pc = this.reg_pc;
        if (this.dsr) {
            this.adsr = this.reg_dsr;
            this.dsr = false;
        } else {
            this.adsr = 0;
        }
        this.executeOP(this.fetch());
        this.reg_pc = Util.shortValue(this.reg_pc);
    }

    public void printRegisters() {
        System.out.print(Util.byteToHex(this.registers[0]));
        int jkl = 1;
        while (jkl < 16) {
            System.out.print(" " + Util.byteToHex(this.registers[jkl]));
            ++jkl;
        }
        System.out.println();
    }

    public void sll(int reg, int val) {
        int a = this.getRegister(reg);
        int result = a << (val &= 7);
        this.PSW_SETBOOL(128, (result & 0x100) != 0);
        this.setRegister(reg, Util.byteValue(result));
    }

    public void sllc(int reg, int val) {
        int a = this.getRegister(reg);
        int b0 = this.getRegister(reg - 1 & 0xF) << (val &= 7);
        int b = b0 >>> 8;
        int result = a << val;
        this.PSW_SETBOOL(128, (result & 0x100) != 0);
        this.setRegister(reg, Util.byteValue(result | b));
    }

    public void srl(int reg, int val) {
        int a = this.getRegister(reg) << 1;
        int result = a >>> (val &= 7);
        this.PSW_SETBOOL(128, (result & 1) != 0);
        this.setRegister(reg, Util.byteValue(result >>> 1));
    }

    public void sra(int reg, int val) {
        int rval = this.getRegister(reg);
        int a = this.getRegister(reg) << 1;
        int carry = a >>> (val &= 7);
        this.PSW_SETBOOL(128, (carry & 1) != 0);
        int result = (byte)rval >> val;
        this.setRegister(reg, Util.byteValue(result));
    }

    public void srlc(int reg, int val) {
        int b0 = this.getRegister(reg + 1 & 0xF) << 8;
        int b = Util.byteValue(b0 >>> (val &= 7));
        int a = this.getRegister(reg) << 1;
        int result = a >>> val;
        this.PSW_SETBOOL(128, (result & 1) != 0);
        this.setRegister(reg, b | Util.byteValue(result >>> 1));
    }

    public boolean hc(int a, int b) {
        int al = a & 0xF;
        int bl = b & 0xF;
        return al + bl > 15;
    }

    public boolean hcC(int a, int b) {
        int al = a & 0xF;
        int bl = b & 0xF;
        int result = al + bl;
        if (this.isFlagSet(128)) {
            ++result;
        }
        return result > 15;
    }

    public boolean oc(int a, int b) {
        int al = a & 0x7F;
        int bl = b & 0x7F;
        return al + bl > 127;
    }

    public boolean ocC(int a, int b) {
        int al = a & 0x7F;
        int bl = b & 0x7F;
        int result = al + bl;
        if (this.isFlagSet(128)) {
            ++result;
        }
        return result > 127;
    }

    public void alu(int t, int reg, int val) {
        val = Util.byteValue(val);
        if (t == 0) {
            this.setRegister(reg, val);
            this.PSW_SETBOOL(64, this.getRegister(reg) == 0);
            this.PSW_SETBOOL(32, (this.getRegister(reg) & 0x80) != 0);
            return;
        }
        if (t == 1) {
            int a = this.getRegister(reg);
            int result = this.add8(a, val);
            this.setRegister(reg, result);
            this.PSW_SETBOOL(64, Util.byteValue(result) == 0);
            this.PSW_SETBOOL(32, (result & 0x80) != 0);
            return;
        }
        if (t == 2) {
            int a = this.getRegister(reg);
            int result = Util.byteValue(a & Util.byteValue(val));
            this.setRegister(reg, result);
            this.PSW_SETBOOL(64, result == 0);
            this.PSW_SETBOOL(32, (result & 0x80) != 0);
            return;
        }
        if (t == 3) {
            int a = this.getRegister(reg);
            int result = Util.byteValue(a | Util.byteValue(val));
            this.setRegister(reg, result);
            this.PSW_SETBOOL(64, result == 0);
            this.PSW_SETBOOL(32, (result & 0x80) != 0);
            return;
        }
        if (t == 4) {
            int a = this.getRegister(reg);
            int result = Util.byteValue(a ^ Util.byteValue(val));
            this.setRegister(reg, result);
            this.PSW_SETBOOL(64, result == 0);
            this.PSW_SETBOOL(32, (result & 0x80) != 0);
            return;
        }
        if (t == 5) {
            int a = this.getRegister(reg);
            int result = 0xFF ^ this.adc8(0xFF ^ a, val);
            boolean prevZ = this.isFlagSet(64);
            this.PSW_SETBOOL(64, prevZ && Util.byteValue(result) == 0);
            this.PSW_SETBOOL(32, (result & 0x80) != 0);
            return;
        }
        if (t == 6) {
            int a = this.getRegister(reg);
            int result = this.adc8(a, val);
            this.setRegister(reg, result);
            boolean prevZ = this.isFlagSet(64);
            this.PSW_SETBOOL(64, prevZ && Util.byteValue(result) == 0);
            this.PSW_SETBOOL(32, (result & 0x80) != 0);
            return;
        }
        if (t == 7) {
            int a = this.getRegister(reg);
            int result = 0xFF ^ this.add8(0xFF ^ a, val);
            this.PSW_SETBOOL(64, Util.byteValue(result) == 0);
            this.PSW_SETBOOL(32, (result & 0x80) != 0);
            return;
        }
        System.err.println("Unimplemented op: " + t);
        while (true) {
            // Infinite loop
        }
    }

    public int add8(int a0, int b0) {
        int a = Util.byteValue(a0);
        int b = Util.byteValue(b0);
        int result = a + b;
        this.PSW_SETBOOL(4, this.hc(a, b));
        this.PSW_SETBOOL(16, this.oc(a, b) ^ result > 255);
        this.PSW_SETBOOL(128, result > 255);
        return Util.byteValue(result);
    }

    public int adc8(int a0, int b0) {
        int a = Util.byteValue(a0);
        int b = Util.byteValue(b0);
        int result = a + b;
        if (this.isFlagSet(128)) {
            ++result;
        }
        this.PSW_SETBOOL(4, this.hcC(a, b));
        this.PSW_SETBOOL(16, this.ocC(a, b) ^ result > 255);
        this.PSW_SETBOOL(128, result > 255);
        return Util.byteValue(result);
    }

    public void alu_sub8(int reg, int val) {
        int a = this.getRegister(reg);
        int result = 0xFF ^ this.add8(0xFF ^ a, val);
        this.setRegister(reg, result);
        this.PSW_SETBOOL(64, Util.byteValue(result) == 0);
        this.PSW_SETBOOL(32, (result & 0x80) != 0);
    }

    public void alu_sbc8(int reg, int val) {
        int a = this.getRegister(reg);
        int result = 0xFF ^ this.adc8(0xFF ^ a, val);
        this.setRegister(reg, result);
        boolean prevZ = this.isFlagSet(64);
        this.PSW_SETBOOL(64, prevZ && Util.byteValue(result) == 0);
        this.PSW_SETBOOL(32, (result & 0x80) != 0);
    }

    public boolean flagsCond(int p) {
        int p1 = p & 0xE;
        if (p1 == 0) {
            return this.isFlagSet(128);
        }
        if (p1 == 2) {
            return this.isFlagSet(64) || this.isFlagSet(128);
        }
        if (p1 == 4) {
            return this.isFlagSet(16) ^ this.isFlagSet(32);
        }
        if (p1 == 6) {
            boolean ovs = this.isFlagSet(16) ^ this.isFlagSet(32);
            return ovs || this.isFlagSet(64);
        }
        if (p1 == 8) {
            return this.isFlagSet(64);
        }
        if (p1 == 10) {
            return this.isFlagSet(16);
        }
        if (p1 == 12) {
            return this.isFlagSet(32);
        }
        if (p1 == 14) {
            return false;
        }
        System.err.println("Unimplemented cond: " + p1);
        while (true) {
            // Infinite loop
        }
    }

    public boolean branchFlags(int p1) {
        int cond;
        int n = cond = this.flagsCond(p1 & 0xE) ? 1 : 0;
        return (p1 & 1) == cond;
    }

    public int add16(int a, int b) {
        int al = a & 0xFF;
        int bl = b & 0xFF;
        int resultL = this.add8(al, bl);
        int ah = Util.byteValue(a >>> 8);
        int bh = Util.byteValue(b >>> 8);
        int resultH = this.adc8(ah, bh);
        int result = resultH << 8 | resultL;
        return result;
    }

    public void op_add16(int reg, int val) {
        int a = this.getERn(reg);
        int result = this.add16(a, val);
        this.PSW_SETBOOL(64, Util.shortValue(result) == 0);
        this.PSW_SETBOOL(32, (result & 0x8000) != 0);
        this.setERn(reg, Util.shortValue(result));
    }

    public void cmp16(int reg, int val) {
        int a = this.getERn(reg);
        int result = 0xFFFF ^ this.add16(0xFFFF ^ a, val);
        this.PSW_SETBOOL(64, Util.shortValue(result) == 0);
        this.PSW_SETBOOL(32, (result & 0x8000) != 0);
    }

    public void mov16(int reg, int val) {
        this.setERn(reg, val);
        this.PSW_SETBOOL(64, this.getERn(reg) == 0);
        this.PSW_SETBOOL(32, (val & 0x8000) != 0);
    }

    public int mul88(int a, int b) {
        int result = Util.shortValue((a = Util.byteValue(a)) * (b = Util.byteValue(b)));
        this.PSW_SETBOOL(64, result == 0);
        return result;
    }

    public void div(int ern, int rm) {
        int a = this.getERn(ern);
        int b = this.getRegister(rm);
        this.PSW_SETBOOL(128, b == 0);
        if (b == 0) {
            return;
        }
        int mod = a % b;
        int div = a / b;
        this.PSW_SETBOOL(64, div == 0);
        this.setERn(ern, div);
        this.setRegister(rm, mod);
    }

    public int disp6(int p23) {
        int imm6 = p23 & 0x3F;
        if ((imm6 & 0x20) != 0) {
            imm6 |= Util.shortValue(65472);
        }
        return imm6;
    }

    public int inc8(int val) {
        int a = Util.byteValue(val);
        int result = a + 1;
        this.PSW_SETBOOL(4, this.hc(a, 1));
        this.PSW_SETBOOL(16, this.oc(a, 1) ^ result > 255);
        this.PSW_SETBOOL(128, result > 255);
        return Util.byteValue(result);
    }

    public int op_inc8(int val) {
        int result = this.inc8(val);
        this.PSW_SETBOOL(64, result == 0);
        this.PSW_SETBOOL(32, (result & 0x80) != 0);
        return result;
    }

    public int dec8(int val) {
        int result = 0xFF ^ this.inc8(val ^ 0xFF);
        this.PSW_SETBOOL(64, result == 0);
        this.PSW_SETBOOL(32, (result & 0x80) != 0);
        return result;
    }

    public int neg8(int val) {
        int result = 0xFF ^ this.add8(255, val);
        this.PSW_SETBOOL(64, Util.byteValue(result) == 0);
        this.PSW_SETBOOL(32, (result & 0x80) != 0);
        return Util.byteValue(result);
    }

    public void daa8(int reg) {
        boolean nc;
        int val = this.getRegister(reg);
        int l = val & 0xF;
        int h = (val & 0xF0) >>> 4;
        boolean hc = this.isFlagSet(4);
        boolean carry = this.isFlagSet(128);
        boolean ov_prev = this.isFlagSet(16);
        int offset = 0;
        if (hc || l > 9) {
            offset |= 6;
        }
        if (carry || h > 9) {
            offset |= 0x60;
        }
        boolean bl = nc = !hc;
        if (h == 9 && l > 9 && nc) {
            offset |= 0x60;
        }
        this.alu(1, reg, offset);
        if (carry) {
            this.PSW_SET(128);
        }
        this.PSW_SETBOOL(16, ov_prev);
    }

    public void das8(int reg) {
        int val = this.getRegister(reg);
        int l = val & 0xF;
        int h = (val & 0xF0) >>> 4;
        boolean hc = this.isFlagSet(4);
        boolean carry = this.isFlagSet(128);
        boolean ov_prev = this.isFlagSet(16);
        int offset = 0;
        if (hc || l > 9) {
            offset |= 6;
        }
        if (carry || h > 9) {
            offset |= 0x60;
        }
        this.alu_sub8(reg, offset);
        if (carry) {
            this.PSW_SET(128);
        }
        this.PSW_SETBOOL(16, ov_prev);
    }

    public void executeOP(int o) {
        int op = o & 0xFFFF;
        int p0 = (op & 0xF000) >>> 12;
        int p1 = (op & 0xF00) >>> 8;
        int p2 = (op & 0xF0) >>> 4;
        int p3 = op & 0xF;
        int p23 = op & 0xFF;
        if ((p0 & 8) == 0) {
            this.alu(p0, p1, p23);
            return;
        }
        if (p0 == 8) {
            if ((p3 & 8) == 0) {
                this.alu(p3, p1, this.getRegister(p2));
                return;
            }
            if (p3 == 8) {
                this.alu_sub8(p1, this.getRegister(p2));
                return;
            }
            if (p3 == 9) {
                this.alu_sbc8(p1, this.getRegister(p2));
                return;
            }
            if (p3 == 10) {
                this.sll(p1, this.getRegister(p2));
                return;
            }
            if (p3 == 11) {
                this.sllc(p1, this.getRegister(p2));
                return;
            }
            if (p3 == 12) {
                this.srl(p1, this.getRegister(p2));
                return;
            }
            if (p3 == 13) {
                this.srlc(p1, this.getRegister(p2));
                return;
            }
            if (p3 == 14) {
                this.sra(p1, this.getRegister(p2));
                return;
            }
            if ((op & 0xF11F) == 33039) {
                this.setERn(p2, Util.shortValue((byte)this.getRegister(p2)));
                return;
            }
            if ((op & 0xF0FF) == 32863) {
                int val = this.neg8(this.getRegister(p1));
                this.setRegister(p1, val);
                return;
            }
            if ((op & 0xF0FF) == 32799) {
                this.daa8(p1);
                return;
            }
            if ((op & 0xF0FF) == 32831) {
                this.das8(p1);
                return;
            }
        }
        if (p0 == 9) {
            if ((op & 0xF08F) == 36874) {
                this.sll(p1, p2);
                return;
            }
            if ((op & 0xF08F) == 36875) {
                this.sllc(p1, p2);
                return;
            }
            if ((op & 0xF08F) == 36876) {
                this.srl(p1, p2);
                return;
            }
            if ((op & 0xF08F) == 36877) {
                this.srlc(p1, p2);
                return;
            }
            if ((op & 0xF08F) == 36878) {
                this.sra(p1, p2);
                return;
            }
            if ((op & 0xFF0F) == 36879) {
                this.dsrPrefix(this.getRegister(p2));
                return;
            }
            if ((op & 0xF11F) == 36866) {
                int erm = this.seg(this.getERn(p2));
                int val = this.core.mem.readDataWord(erm);
                this.loadERn(p1, val);
                return;
            }
            if ((op & 0xF01F) == 36864) {
                int erm = this.seg(this.getERn(p2));
                int val = this.core.mem.readDataByte(erm);
                this.loadRegister(p1, Util.byteValue(val));
                return;
            }
            if ((op & 0xF01F) == 36872) {
                int disp16 = this.fetch();
                int erm = this.seg(disp16 + this.getERn(p2));
                int val = this.core.mem.readDataByte(erm);
                this.loadRegister(p1, Util.byteValue(val));
                return;
            }
            if ((op & 0xF0FF) == 36880) {
                int addr = this.seg(this.fetch());
                this.loadRegister(p1, this.core.mem.readDataByte(addr));
                return;
            }
            if ((op & 0xF1FF) == 36882) {
                int addr = this.seg(this.fetch());
                this.loadERn(p1, this.core.mem.readDataWord(addr));
                return;
            }
            if ((op & 0xF0FF) == 36912) {
                int val = this.fetchDataByte(false);
                this.loadRegister(p1, val);
                return;
            }
            if ((op & 0xF0FF) == 36944) {
                int val = this.fetchDataByte(true);
                this.loadRegister(p1, val);
                return;
            }
            if ((op & 0xF0FF) == 36913) {
                this.dropDataByte(this.getRegister(p1), false);
                return;
            }
            if ((op & 0xF0FF) == 36945) {
                this.dropDataByte(this.getRegister(p1), true);
                return;
            }
            if ((op & 0xF1FF) == 36914) {
                int val = this.fetchDataShort(false);
                this.loadERn(p1, val);
                return;
            }
            if ((op & 0xF1FF) == 36946) {
                int val = this.fetchDataShort(true);
                this.loadERn(p1, val);
                return;
            }
            if ((op & 0xF1FF) == 36915) {
                this.dropDataShort(this.getERn(p1), false);
                return;
            }
            if ((op & 0xF1FF) == 36947) {
                this.dropDataShort(this.getERn(p1), true);
                return;
            }
            if ((op & 0xF3FF) == 36916) {
                int val = this.fetchDataInt(false);
                this.loadXRn(p1, val);
                return;
            }
            if ((op & 0xF3FF) == 36948) {
                int val = this.fetchDataInt(true);
                this.loadXRn(p1, val);
                return;
            }
            if ((op & 0xF3FF) == 36917) {
                this.dropDataInt(this.getXRn(p1), false);
                return;
            }
            if ((op & 0xF3FF) == 36949) {
                this.dropDataInt(this.getXRn(p1), true);
                return;
            }
            if ((op & 0xF7FF) == 36918) {
                this.fetchDataQR(p1, false);
                return;
            }
            if ((op & 0xF7FF) == 36950) {
                this.fetchDataQR(p1, true);
                return;
            }
            if ((op & 0xF7FF) == 36919) {
                this.dropDataQR(p1, false);
                return;
            }
            if ((op & 0xF7FF) == 36951) {
                this.dropDataQR(p1, true);
                return;
            }
            if ((op & 0xF11F) == 36867) {
                int erm = this.seg(this.getERn(p2));
                this.core.mem.writeDataWord(erm, this.getERn(p1));
                return;
            }
            if ((op & 0xF01F) == 36865) {
                int erm = this.seg(this.getERn(p2));
                this.core.mem.writeDataByte(erm, this.getRegister(p1));
                return;
            }
            if ((op & 0xF01F) == 36873) {
                int disp16 = this.fetch();
                int erm = this.seg(disp16 + this.getERn(p2));
                this.core.mem.writeDataByte(erm, this.getRegister(p1));
                return;
            }
            if ((op & 0xF0FF) == 36881) {
                int addr = this.fetch();
                this.core.mem.writeDataByte(this.seg(addr), this.getRegister(p1));
                return;
            }
            if ((op & 0xF1FF) == 36883) {
                int addr = this.fetch();
                this.core.mem.writeDataWord(this.seg(addr), this.getERn(p1));
                return;
            }
        }
        if (p0 == 10) {
            if ((op & 0xF08F) == 40960) {
                int mask;
                int reg = this.getRegister(p1);
                this.PSW_SETBOOL(64, (reg & (mask = 1 << (p2 & 7))) == 0);
                this.setRegister(p1, reg | mask);
                return;
            }
            if ((op & 0xF08F) == 40961) {
                int mask;
                int reg = this.getRegister(p1);
                this.PSW_SETBOOL(64, (reg & (mask = 1 << (p2 & 7))) == 0);
                return;
            }
            if ((op & 0xF08F) == 40962) {
                int mask;
                int reg = this.getRegister(p1);
                this.PSW_SETBOOL(64, (reg & (mask = 1 << (p2 & 7))) == 0);
                this.setRegister(p1, reg & (0xFF ^ mask));
                return;
            }
            if ((op & 0xFF8F) == 41089) {
                int mask;
                int addr = this.seg(this.fetch());
                int reg = this.core.mem.readDataByte(addr);
                this.PSW_SETBOOL(64, (reg & (mask = 1 << (p2 & 7))) == 0);
                return;
            }
            if ((op & 0xFF8F) == 41090) {
                int mask;
                int addr = this.seg(this.fetch());
                int reg = this.core.mem.readDataByte(addr);
                this.PSW_SETBOOL(64, (reg & (mask = 1 << (p2 & 7))) == 0);
                this.core.mem.writeDataByte(addr, reg & (0xFF ^ mask));
                return;
            }
            if ((op & 0xFF8F) == 41088) {
                int mask;
                int addr = this.seg(this.fetch());
                int reg = this.core.mem.readDataByte(addr);
                this.PSW_SETBOOL(64, (reg & (mask = 1 << (p2 & 7))) == 0);
                this.core.mem.writeDataByte(addr, reg | mask);
                return;
            }
            if ((op & 0xF1FF) == 40986) {
                this.setERn(p1, Util.shortValue(this.reg_sp));
                return;
            }
            if ((op & 0xFF1F) == 41226) {
                this.reg_sp = (short)Util.shortValue(this.getERn(p2));
                return;
            }
            if ((op & 0xF11F) == 40968) {
                int disp16 = this.fetch();
                int erm = this.seg(disp16 + this.getERn(p2));
                int val = this.core.mem.readDataWord(erm);
                this.loadERn(p1, val);
                return;
            }
            if ((op & 0xF11F) == 40969) {
                int disp16 = this.fetch();
                int erm = this.seg(disp16 + this.getERn(p2));
                this.core.mem.writeDataWord(erm, this.getERn(p1));
                return;
            }
            if ((op & 0xF0FF) == 40963) {
                this.setRegister(p1, Util.byteValue(this.reg_psw));
                return;
            }
            if ((op & 0xF0FF) == 40964) {
                this.setRegister(p1, Util.byteValue(this.reg_epsw[this.getELVL()]));
                return;
            }
            if ((op & 0xF1FF) == 40965) {
                this.setERn(p1, Util.shortValue(this.reg_elr[this.getELVL()]));
                return;
            }
            if ((op & 0xF0FF) == 40967) {
                this.setRegister(p1, Util.byteValue(this.reg_ecsr[this.getELVL()]));
                return;
            }
            if ((op & 0xFF0F) == 40971) {
                this.reg_psw = (byte)this.getRegister(p2);
                return;
            }
            if ((op & 0xFF0F) == 40972) {
                this.reg_epsw[this.getELVL()] = (byte)this.getRegister(p2);
                return;
            }
            if ((op & 0xF1FF) == 40973) {
                this.reg_elr[this.getELVL()] = (short)this.getERn(p1);
                return;
            }
            if ((op & 0xFF0F) == 40975) {
                this.reg_ecsr[this.getELVL()] = (byte)this.getRegister(p2);
                return;
            }
        }
        if (p0 == 11) {
            if ((op & 0xF1C0) == 45120) {
                int fp = this.getFP();
                int addr = this.seg(Util.shortValue(fp + this.disp6(p23)));
                this.loadERn(p1, this.core.mem.readDataWord(addr));
                return;
            }
            if ((op & 0xF1C0) == 45248) {
                int fp = this.getFP();
                int addr = this.seg(Util.shortValue(fp + this.disp6(p23)));
                this.core.mem.writeDataWord(addr, this.getERn(p1));
                return;
            }
            if ((op & 0xF1C0) == 45056) {
                int bp = this.getBP();
                int addr = this.seg(Util.shortValue(bp + this.disp6(p23)));
                this.loadERn(p1, this.core.mem.readDataWord(addr));
                return;
            }
            if ((op & 0xF1C0) == 45184) {
                int bp = this.getBP();
                int addr = this.seg(Util.shortValue(bp + this.disp6(p23)));
                this.core.mem.writeDataWord(addr, this.getERn(p1));
                return;
            }
        }
        if (p0 == 12) {
            boolean b = this.branchFlags(p1);
            if (b) {
                byte off = (byte)p23;
                this.reg_pc += off << 1;
            }
            return;
        }
        if (p0 == 13) {
            if ((op & 0xF0C0) == 53248) {
                int bp = this.getBP();
                int addr = this.seg(Util.shortValue(bp + this.disp6(p23)));
                this.loadRegister(p1, this.core.mem.readDataByte(addr));
                return;
            }
            if ((op & 0xF0C0) == 53312) {
                int fp = this.getFP();
                int addr = this.seg(Util.shortValue(fp + this.disp6(p23)));
                this.loadRegister(p1, this.core.mem.readDataByte(addr));
                return;
            }
            if ((op & 0xF0C0) == 53376) {
                int bp = this.getBP();
                int addr = this.seg(Util.shortValue(bp + this.disp6(p23)));
                this.core.mem.writeDataByte(addr, this.getRegister(p1));
                return;
            }
            if ((op & 0xF0C0) == 53440) {
                int fp = this.getFP();
                int addr = this.seg(Util.shortValue(fp + this.disp6(p23)));
                this.core.mem.writeDataByte(addr, this.getRegister(p1));
                return;
            }
        }
        if (p0 == 14) {
            if ((op & 0xF180) == 57472) {
                int imm7 = p23 & 0x7F;
                if ((imm7 & 0x40) != 0) {
                    imm7 |= Util.shortValue(65408);
                }
                this.op_add16(p1 & 0xE, imm7);
                return;
            }
            if ((op & 0xF180) == 57344) {
                int imm7 = p23 & 0x7F;
                if ((imm7 & 0x40) != 0) {
                    imm7 |= Util.shortValue(65408);
                }
                this.mov16(p1 & 0xE, imm7);
                return;
            }
            if ((op & 0xFF00) == 57600) {
                this.reg_sp = (short)(this.reg_sp + (byte)p23);
                return;
            }
            if ((op & 0xFF00) == 58112) {
                this.dsrPrefix(p23);
                return;
            }
            if ((op & 0xFFC0) == 58624) {
                int snum = p23 & 0x3F;
                this.raise(1, snum | 0x40);
                return;
            }
            if (op == 60680) {
                this.PSW_SET(8);
                return;
            }
            if (op == 60407) {
                this.PSW_CLEAR(8);
                return;
            }
            if (op == 60287) {
                this.PSW_CLEAR(128);
                return;
            }
            if (op == 60800) {
                this.PSW_SET(128);
                return;
            }
            if ((op & 0xFF00) == 59648) {
                this.reg_psw = (byte)p23;
                return;
            }
        }
        if (p0 == 15) {
            if ((op & 0xF11F) == 61445) {
                this.mov16(p1, this.getERn(p2));
                return;
            }
            if ((op & 0xF11F) == 61446) {
                this.op_add16(p1, this.getERn(p2));
                return;
            }
            if ((op & 0xF11F) == 61447) {
                this.cmp16(p1, this.getERn(p2));
                return;
            }
            if ((op & 0xF00F) == 61444) {
                int a = this.getRegister(p1);
                int b = this.getRegister(p2);
                this.setERn(p1, this.mul88(a, b));
                return;
            }
            if ((op & 0xF10F) == 61449) {
                this.div(p1, p2);
                return;
            }
            if ((op & 0xF0FF) == 61518) {
                this.core.mem.pushByteToStack(this.getRegister(p1));
                return;
            }
            if ((op & 0xF1FF) == 61534) {
                this.core.mem.pushWordToStack(this.getERn(p1));
                return;
            }
            if ((op & 0xF3FF) == 61550) {
                this.core.mem.pushIntToStack(this.getXRn(p1));
                return;
            }
            if ((op & 0xF7FF) == 61566) {
                this.core.mem.pushIntToStack(this.getXRn(p1 + 4));
                this.core.mem.pushIntToStack(this.getXRn(p1));
                return;
            }
            if ((op & 0xF0FF) == 61454) {
                int val = Util.byteValue(this.core.mem.popByteFromStack());
                this.setRegister(p1, val);
                return;
            }
            if ((op & 0xF1FF) == 61470) {
                int val = Util.shortValue(this.core.mem.popWordFromStack());
                this.setERn(p1, val);
                return;
            }
            if ((op & 0xF3FF) == 61486) {
                int val = this.core.mem.popIntFromStack();
                this.setXRn(p1, val);
                return;
            }
            if ((op & 0xF7FF) == 61502) {
                int val = this.core.mem.popIntFromStack();
                int val2 = this.core.mem.popIntFromStack();
                this.setXRn(p1, val);
                this.setXRn(p1 + 4, val2);
                return;
            }
            if ((op & 0xF0FF) == 61646) {
                if ((p1 & 2) != 0) {
                    int elvl = this.getELVL();
                    if (this.hasCSR) {
                        this.core.mem.pushWordToStack(Util.byteValue(this.reg_ecsr[elvl]));
                    }
                    this.core.mem.pushWordToStack(Util.shortValue(this.reg_elr[elvl]));
                }
                if ((p1 & 4) != 0) {
                    this.core.mem.pushByteToStack(Util.byteValue(this.reg_epsw[this.getELVL()]));
                }
                if ((p1 & 8) != 0) {
                    if (this.hasCSR) {
                        this.core.mem.pushByteToStack(this.getLCSR());
                    }
                    this.core.mem.pushWordToStack(this.getLR());
                }
                if ((p1 & 1) != 0) {
                    this.core.mem.pushWordToStack(Util.shortValue(this.reg_ea));
                }
                return;
            }
            if ((op & 0xF0FF) == 61582) {
                if ((p1 & 1) != 0) {
                    this.reg_ea = (short)Util.shortValue(this.core.mem.popWordFromStack());
                }
                if ((p1 & 8) != 0) {
                    this.setLR(this.core.mem.popWordFromStack());
                    if (this.hasCSR) {
                        this.setLCSR(this.core.mem.popByteFromStack());
                    }
                }
                if ((p1 & 4) != 0) {
                    this.reg_psw = (byte)this.core.mem.popByteFromStack();
                }
                if ((p1 & 2) != 0) {
                    this.reg_pc = Util.shortValue(this.core.mem.popWordFromStack());
                    if (this.hasCSR) {
                        this.reg_csr = (byte)this.core.mem.popByteFromStack();
                    }
                }
                return;
            }
            if (op == 65055) {
                this.reg_pc = this.getLR();
                this.reg_csr = (byte)this.getLCSR();
                return;
            }
            if (op == 65039) {
                int elvl = this.getELVL();
                this.reg_pc = Util.shortValue(this.reg_elr[elvl]);
                this.reg_csr = (byte)Util.byteValue(this.reg_ecsr[elvl]);
                this.reg_psw = (byte)Util.byteValue(this.reg_epsw[elvl]);
                this.setELVL(0);
                return;
            }
            if (op == 65071) {
                int val = this.fetchDataByte(false);
                this.dropDataByte(this.op_inc8(val), false);
                return;
            }
            if (op == 65087) {
                int val = this.fetchDataByte(false);
                this.dropDataByte(this.dec8(val), false);
                return;
            }
            if (op == 65167) {
                return;
            }
            if (op == 65183) {
                this.dsr = true;
                return;
            }
            if (op == 65231) {
                this.PSW_SETBOOL(128, !this.isFlagSet(128));
                return;
            }
            if (op == 65535) {
                if ((this.getELVL() & 0xFE) == 0) {
                    this.raise(2, 2);
                } else {
                    this.reset();
                    this.raise(0, 1);
                }
                return;
            }
            if (op == 61452) {
                int dadr = this.fetch();
                this.reg_ea = (short)dadr;
                return;
            }
            if ((op & 0xFF1F) == 61450) {
                this.reg_ea = (short)this.getERn(p2);
                return;
            }
            if ((op & 0xFF1F) == 61451) {
                int disp16 = this.fetch();
                int newea = this.getERn(p2) + disp16;
                this.reg_ea = (short)Util.shortValue(newea);
                return;
            }
            if ((op & 0xFF1E) == 61442) {
                int cadr = this.getERn(p2);
                if ((p3 & 1) == 1) {
                    this.setLR(this.reg_pc);
                    this.setLCSR(this.reg_csr);
                }
                this.reg_pc = cadr & 0xFFFF;
                return;
            }
            if ((op & 0xF0FE) == 61440) {
                int cadr = this.fetch();
                if ((p3 & 1) == 1) {
                    this.setLR(this.reg_pc);
                    this.setLCSR(this.reg_csr);
                }
                this.reg_pc = cadr & 0xFFFF;
                this.reg_csr = (byte)p1;
                return;
            }
        }
        try {
            throw new RuntimeException("unimplemented instruction: 0x" + Util.shortToHex((short)op));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.core.emu.setPause(true);
            return;
        }
    }

    public void raise(int l, int indx) {
        if (l == 1) {
            this.PSW_SETBOOL(8, false);
        }
        int lpsw = Util.byteValue(this.reg_psw);
        this.setELVL(l);
        this.reg_epsw[this.getELVL()] = (byte)lpsw;
        this.reg_elr[this.getELVL()] = (short)this.reg_pc;
        this.reg_ecsr[this.getELVL()] = this.reg_csr;
        this.reg_csr = 0;
        this.reg_pc = this.core.mem.readCode(indx << 1);
    }

    public boolean mie() {
        return this.isFlagSet(8);
    }

    public void dsrPrefix(int val) {
        this.reg_dsr = (byte)Util.byteValue(val);
        this.dsr = true;
    }

    public void reset() {
        this.reg_sp = (short)this.core.mem.readCode(0);
        this.setELVL(0);
        this.reg_dsr = 0;
        this.reg_psw = 0;
        this.reg_csr = 0;
    }

    public boolean isFlagSet(int x) {
        return (this.flags() & Util.byteValue(x)) != 0;
    }

    public int flags() {
        return Util.byteValue(this.reg_psw) & 0xFF;
    }

    final int PSW_ISSET(int x) {
        return this.flags() & Util.byteValue(x);
    }

    final int PSW_SET(int x) {
        this.reg_psw = (byte)(this.flags() | Util.byteValue(x));
        return this.flags();
    }

    final int PSW_SETBOOL(int x, boolean b) {
        if (b) {
            this.PSW_SET(x);
        } else {
            this.PSW_CLEAR(x);
        }
        return this.flags();
    }

    final int PSW_CLEAR(int x) {
        int p1 = x & 0xFF;
        this.reg_psw = (byte)(this.flags() & (0xFFFF ^ p1));
        return this.flags();
    }
}

