/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.calc.romtools;

import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import net.enderkitty.beucalc.Util;
import net.enderkitty.calc.romtools.MenuButton;
import net.enderkitty.calc.romtools.ROM;

public class MenuViewer
extends Panel
implements Runnable {
    public static int menu_start = 8628;
    public BufferedImage bufferedScreen = new BufferedImage(560, 440, 1);
    public BufferedImage output;
    public int next;
    public int prev;
    public int menu;
    public int[] menuLines;
    public String[] stringData;

    public void start() {
        this.setSize(1024, 768);
        new Thread(this).start();
        this.setLayout(null);
        this.initButtons();
    }

    public void initButtons() {
        Button b = new Button();
        b.setBounds(144, 176, 48, 32);
        b.setLabel("BACK");
        b.addMouseListener(new MenuButton(this, -1));
        this.add(b);
        Button b2 = new Button();
        b2.setBounds(200, 158, 48, 32);
        b2.setLabel("UP");
        b2.addMouseListener(new MenuButton(this, -2));
        this.add(b2);
        Button b3 = new Button();
        b3.setBounds(200, 194, 48, 32);
        b3.setLabel("DOWN");
        b3.addMouseListener(new MenuButton(this, -3));
        this.add(b3);
        Button b4 = new Button();
        b4.setBounds(320, 158, 64, 24);
        b4.setLabel("INC MENU");
        b4.addMouseListener(new MenuButton(this, -4));
        this.add(b4);
        this.addOptionButton(0, 136, 320);
        this.addOptionButton(1, 172, 320);
        this.addOptionButton(2, 208, 320);
        this.addOptionButton(3, 136, 284);
        this.addOptionButton(4, 172, 284);
        this.addOptionButton(5, 208, 284);
        this.addOptionButton(6, 136, 248);
        this.addOptionButton(7, 172, 248);
    }

    public void addOptionButton(int id, int x, int y) {
        Button b = new Button();
        b.setBounds(x, y, 32, 32);
        b.setLabel("" + (id + 1));
        b.addMouseListener(new MenuButton(this, id));
        this.add(b);
    }

    @Override
    public void run() {
        this.output = new BufferedImage(96, 33, 1);
        this.menuLines = new int[4];
        this.menu = -1;
        this.next = 2;
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fonts.length) {
            System.out.println(fonts[i]);
            ++i;
        }
        while (true) {
            if (menu_start != 0) {
                this.tick();
            }
            this.repaint();
        }
    }

    public void tick() {
        if (this.next != this.menu) {
            this.nextMenu();
            this.updateStrings();
            this.updateOutput();
        }
    }

    public void nextMenu() {
        this.prev = this.menu;
        this.menu = this.next;
        this.menuLines[0] = 0;
        int line = 0;
        int addr = this.getMenuShort(0);
        int indx = 0;
        while (line < 3) {
            int chr = ROM.getByte(addr + indx);
            ++indx;
            if (chr != 0) continue;
            this.menuLines[++line] = indx;
        }
    }

    public void updateStrings() {
        this.stringData = new String[4];
        int addr = this.getMenuShort(0);
        int i = 0;
        while (i < 4) {
            int indx = this.menuLines[i];
            if (ROM.getByte(addr + indx) != 0) {
                int strAddr = addr + indx;
                int strI = 0;
                this.stringData[i] = "";
                while (strI < 16 && ROM.getByte(strAddr + strI) != 0) {
                    int n = i;
                    this.stringData[n] = String.valueOf(this.stringData[n]) + (char)ROM.getByte(strAddr + strI);
                    ++strI;
                }
            }
            ++i;
        }
    }

    public void updateOutput() {
        this.clearScreen();
        Graphics g2 = this.output.getGraphics();
        g2.setFont(new Font("ESPScreen Small", 0, 8));
        g2.setColor(new Color(0x222266));
        int i = 0;
        while (i < this.stringData.length) {
            String str = this.stringData[i];
            if (str != null) {
                g2.drawString(str, 0, 8 + 8 * i);
            }
            ++i;
        }
    }

    public void clearScreen() {
        int[] mData = ((DataBufferInt)this.output.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < mData.length) {
            mData[i] = 0xBBEECC;
            ++i;
        }
        i = 0;
        while (i < 24) {
            mData[i << 2] = 0;
            ++i;
        }
        i = 96;
        while (i < 3072) {
            mData[i] = 0x99CCCC;
            ++i;
        }
    }

    public int getMenuAddr() {
        return menu_start + (this.menu << 4);
    }

    public int getMenuByte(int i) {
        return ROM.getByte(this.getMenuAddr() + i);
    }

    public int getMenuShort(int i) {
        return ROM.getShort(this.getMenuAddr() + i);
    }

    public void gotoMenu(int id) {
        if (id != 0) {
            this.next = id;
        }
    }

    public void optionButton(int id) {
        boolean submenu;
        int val = this.getMenuByte(4 + id);
        int test = 1 << (7 ^ id);
        boolean bl = submenu = (this.getMenuByte(2) & test) == 0;
        if (submenu) {
            this.gotoMenu(val);
        }
    }

    public void upButton() {
        this.gotoMenu(this.getMenuByte(12));
    }

    public void downButton() {
        this.gotoMenu(this.getMenuByte(13));
    }

    public void leftButton() {
        int val = this.getMenuByte(14);
        if ((val & 0xFC) == 252) {
            this.gotoMenu(this.prev);
        } else {
            this.gotoMenu(this.getMenuByte(14));
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int[] mData = ((DataBufferInt)this.bufferedScreen.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < mData.length) {
            mData[i] = 0x6F6F6F;
            ++i;
        }
        g.setColor(new Color(0xFFFFFF));
        this.renderOutput();
        this.renderInfo();
        this.getGraphics().drawImage(this.bufferedScreen, 0, 0, null);
    }

    public void renderInfo() {
        Graphics g = this.bufferedScreen.getGraphics();
        int offset0 = 420;
        g.drawString("Menu Info: ", offset0, 36);
        g.drawString("Menu: " + Util.byteToHex((byte)this.menu), offset0, 60);
        g.drawString("TextAddr: " + Util.shortToHex(this.get16(0)), offset0, 76);
        g.drawString("OptMask: " + Util.byteToBinary(this.get8(2)), offset0, 88);
        g.drawString("idk: " + Util.byteToBinary(this.get8(3)), offset0, 100);
        int i = 0;
        while (i < 8) {
            g.drawString("Opt_" + (i + 1) + ": " + Util.byteToHex(this.get8(4 + i)), offset0, 112 + i * 12);
            ++i;
        }
        g.drawString("UP: " + Util.byteToHex(this.get8(12)), offset0, 210);
        g.drawString("DOWN: " + Util.byteToHex(this.get8(13)), offset0, 222);
        g.drawString("BACK: " + Util.byteToHex(this.get8(14)), offset0, 234);
        g.drawString("KEY: " + Util.byteToHex(this.get8(15)), offset0, 246);
    }

    public byte get8(int i) {
        return (byte)this.getMenuByte(i);
    }

    public short get16(int i) {
        return (short)this.getMenuShort(i);
    }

    public void renderOutput() {
        this.bufferedScreen.getGraphics().drawImage(this.output, 16, 16, 384, 132, null);
    }

    public static void main(String[] args) {
        Frame frame = new Frame();
        frame.setSize(744, 640);
        MenuViewer tst = new MenuViewer();
        ROM.loadRom(new File("roms/cy-864a_emu.bin"));
        frame.add(tst);
        frame.setBackground(Color.BLACK);
        frame.setVisible(true);
        frame.setTitle("MenuViewer");
    }
}

