/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.calc.romtools;

import java.io.File;
import net.enderkitty.beucalc.Util;

public class PModder {
    public static byte[] dat;

    public static int readByte(int addr) {
        return Util.byteValue(dat[addr]);
    }

    public static int readWord(int addr) {
        int waddr = addr & 0xFFFFFE;
        int l = PModder.readByte(waddr);
        int h = PModder.readByte(waddr | 1);
        return h << 8 | l;
    }

    public static void writeByte(int addr, int val) {
        PModder.dat[addr] = (byte)Util.byteValue(val);
    }

    public static void writeWord(int addr, int val) {
        int waddr = addr & 0xFFFFFE;
        int l = val & 0xFF;
        int h = val >>> 8 & 0xFF;
        PModder.writeByte(waddr, l);
        PModder.writeByte(waddr | 1, h);
    }

    public static void main(String[] args) {
        dat = Util.loadBin(new File("roms/gy344flash.bin"), 524288);
        int i = 0;
        while (i < 100352) {
            int indx = 262144 + (i << 1);
            if (PModder.readWord(indx) == 63694) {
                PModder.writeWord(indx, 65280);
                PModder.writeWord(indx + 2, 16384);
            }
            System.out.println(Util.rgbToHex(indx));
            ++i;
        }
        Util.saveBin("roms/gy344mod.bin", dat);
    }
}

